import java.util.*;
import java.io.*;

/** WA solution which assumes the shortest paths don't intersect each other. */
public class RoadToSavings_Micah_WA {
    public static void main(String[] args) throws IOException {
        
        // Read and store input
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String[] line = br.readLine().split(" ");
        int n = Integer.parseInt(line[0]);
        int m = Integer.parseInt(line[1]);
        int a = Integer.parseInt(line[2]) - 1;
        int b = Integer.parseInt(line[3]) - 1;
        int[][] dist = new int[n][n];
        int totalLength = 0;
        for (int i = 0; i < m; i++) {
            line = br.readLine().split(" ");
            int u = Integer.parseInt(line[0]) - 1;
            int v = Integer.parseInt(line[1]) - 1;
            int l = Integer.parseInt(line[2]);
            dist[u][v] = dist[v][u] = l;
            totalLength += l;
        }

        // Compute shortest path (and count how many shortest paths there are)
        PriorityQueue<Node> queue = new PriorityQueue<>();
        queue.add(new Node(a, 0));
        int[] nShortestPaths = new int[n];
        nShortestPaths[a] = 1;
        while (queue.size() > 0) {
          Node node = queue.poll();
          int u = node.index;

          if (u == b) {
            // This implementation assumes that no shortest path intersects another one
            System.out.println(totalLength - (node.distance * nShortestPaths[u]));
            return;
          }

          for (int v = 0; v < n; v++) {
            int newDistance = dist[a][u] + dist[u][v];
            if (dist[u][v] > 0 && (dist[a][v] == 0 || newDistance <= dist[a][v])) {
              dist[a][v] = newDistance;
              nShortestPaths[v] += nShortestPaths[u];
              queue.add(new Node(v, newDistance));
            }
          }
        }
    }

    static class Node implements Comparable<Node> {
      int index;
      int distance;
      Node(int index, int distance) {
        this.index = index;
        this.distance = distance;
      }
      @Override
      public int compareTo(Node other) {
        return distance - other.distance;
      }
    }
}
