import java.util.Scanner;

public class SimpleSolitaireWA_John {

	public static Scanner in = new Scanner(System.in);
	public static CardWA [] hand = new CardWA[52];
	public static final boolean DEBUG = true;
	
	public static void main(String[] args) {

		int j = 0, i=0;
		boolean dealCard = true;
		while (i < 52 || !dealCard) {
			if (dealCard) {
				String s = in.next();
				hand[j] = new CardWA(s.charAt(0), s.charAt(1));
				if (DEBUG) printHand(j+1);
				i++;
			}
			if (j >= 3 && hand[j-3].rank == hand[j].rank) {
				j -= 4;
				if (DEBUG) printHand(j+1);
				dealCard = false;
			}
			if (j >= 4 && hand[j-4].rank == hand[j-1].rank) {
				hand[j-4] = hand[j];
				j -= 4;
				if (DEBUG) printHand(j+1);
				dealCard = false;
			}
			else if (j >= 3 && hand[j-3].suit == hand[j].suit) {
				hand[j-3] = hand[j-2];
				hand[j-2] = hand[j-1];
				j -= 2;
				if (DEBUG) printHand(j+1);
				dealCard = false;
			}
			else if (j >= 4 && hand[j-4].suit == hand[j-1].suit) {
				hand[j-4] = hand[j-3];
				hand[j-3] = hand[j-2];
				hand[j-2] = hand[j];
				j -= 2;
				if (DEBUG) printHand(j+1);
				dealCard = false;
			}
			else {
				dealCard = true;
				j++;
//				if (DEBUG) printHand(j);
			}
		}
		printHand(j);
	}
	
	public static void printHand(int num)
	{
		System.out.print(num);
		for(int i=0; i<num; i++) {
			System.out.print(" " + hand[i]);
		}
		System.out.println();
		
	}

}

class CardWA
{
	char rank, suit;
	
	public CardWA(char r, char s)
	{
		rank = r;
		suit = s;
	}
	
	public String toString()
	{
		return ""+rank+suit;
	}
}

