import java.util.Scanner;
import java.util.Arrays;

public class Broadband_JPB {

	public static final int MAXH = 1000;
	public static final int MAXT = 100;
	
	public static void main(String[] args) {
		
		Scanner in = new Scanner(System.in);
		int m = in.nextInt();
		int n = in.nextInt();
		int k = in.nextInt();
		int s = in.nextInt();
		
		double [] locs = new double[m+n];
		for(int i=0; i<m+n; i++) {
			locs[i] = in.nextDouble();
		}
		Arrays.sort(locs);
		
		double [][] table = new double[n+m][k+1];	// table[i][j] = optimal distance using j towers for first i locations
		double [][] means = new double[n+m][n+m];	// means[i][j] = mean of locations from i to j inclusive, i<=j
		double [][] sqSums = new double[n+m][n+m];	// sqSums[i][j] = sum of (locs-mean)^2 from i to j inclusive, i<=j
		
		for(int i=0; i<n+m; i++) {
			means[i][i] = locs[i];
			double sum = locs[i];
			for(int j=i+1; j<n+m; j++) {
				sum += locs[j];
				means[i][j] = sum/(j-i+1);
			}
		}
										// sum (locs - means)^2 = sum(loc)^2 - n(means)^2
		for(int i=0; i<n+m; i++) {
			sqSums[i][i] = 0;
			for(int j=i+1; j<n+m; j++) {
				sqSums[i][j] = sqSums[i][j-1] + locs[j]*locs[j] + (j-i)*means[i][j-1]*means[i][j-1] - (j-i+1)*means[i][j]*means[i][j];
			}
		}
/*
		for(int i=0; i<n+m; i++) {
			System.out.print(i+":");
			for(int j=i; j<n+m; j++) {
				System.out.printf(" %10.5f", means[i][j]);
			}
			System.out.println();
		}
/**/
/*
		for(int i=0; i<n+m; i++) {
			System.out.print(i+":");
			for(int j=i; j<n+m; j++) {
				System.out.printf(" %10.5f", sqSums[i][j]);
			}
			System.out.println();
		}
/**/
		for(int i=0; i<k; i++) {
			table[i][i+1] = 0.0;				// 0 cost if same number of towers as customers
		}
		for(int i=0; i<n+m; i++) {
			table[i][1] = sqSums[0][i];			// cost is just sqSum with only 1 tower
		}
		
		for(int j=2; j<=k; j++) {
			for(int i=j; i<n+m; i++) {
				double min = table[i-1][j-1] + sqSums[i][i];
//System.out.println(j+","+i+","+(i-1)+": min = " + min);
				for(int l=i-2; l>=j-1; l--) {
//System.out.print("  l=" + l + ": " + table[l][j-1] + " " + sqSums[l+1][i]);
					if (table[l][j-1] + sqSums[l+1][i] < min) {	// cost of j-th tower covering customers l+1 to i plus optimal way to cover first l customers with j-1 towers
						min = table[l][j-1] + sqSums[l+1][i];
//						System.out.println(": min updated = " + min);
					}
//					else System.out.println();
					
				}
				table[i][j] = min;
			}
		}
/*
		for(int i=0; i<n+m; i++) {
			System.out.print(i+":");
			for(int j=1; j<=k; j++) {
				System.out.printf(" %10.5f", table[i][j]);
			}
			System.out.println();
		}
/**/
		System.out.printf("%f\n",(n+m)*s*s/4.0 + table[n+m-1][k]);
	}

}
