#include <iostream>
#include <algorithm>
#include <cmath>
using namespace std;

double** d;
int n;

double findmin(int k, int j) {
  if (k==1) {
    return d[j][n];
  }
  double m = 1E9;
  for (int i = j; i <= n-k+1; i++) {
    double x = findmin(k-1,i+1);
    m = min(m,d[j][i]+x);
  }
  return m;
}

int main() {
  int m, k, s;
  cin >> m >> n >> k >> s;
  double x[m+n+1];
  double temp;
  for (int i = 1; i <= m; i++) {
    cin >> x[i];
  }
  for (int i = m+1; i <= m+n; i++) {
    cin >> x[i];
  }
  n = m+n;
  x[0] = -1e12;
  sort(x,x+n+1);

  double mu[n+1][n+1];
  for (int i = 1; i <= n; i++) {
    mu[i][i] = x[i];
    for (int j = i+1; j <= n; j++) {
      mu[i][j] = (x[j] +(j-i)*mu[i][j-1])/(j-i+1);
    }
  }

  d = new double*[n+1];
  for (int i = 0; i <= n; i++)
    d[i] = new double[n+1];

  for (int i = 1; i <= n; i++) {
    d[i][i] = 0;
    for (int j = i+1; j <= n; j++) {
      d[i][j] = d[i][j-1]+(j-i)*1.0/(j-i+1)*pow(x[j]-mu[i][j-1],2);
    }
  }

  double ans = findmin(k,1);
  cout << ans+n*pow(s/2.0,2) << endl;
}
