#!/usr/bin/env python3

# Based on "Optimal k-means Clustering in One Dimension by Dynamic Programming"
# (https://journal.r-project.org/archive/2011-2/RJournal_2011-2_Wang+Song.pdf)

import sys

def findmin(k,j):
  if k==1:
    return d[j][n]
  m = 1E9
  for i in range(j,n-k+2):
    x = findmin(k-1,i+1)
    m = min(m,d[j][i]+x)
  return m

[n,m,k,s] = list(map(int,sys.stdin.readline().split()))
x = list(map(float,sys.stdin.readline().split()))
x = x+list(map(float,sys.stdin.readline().split()))
x.sort()
x = [None]+x

n = n+m

mu = [[None for i in range(n+1)] for j in range(n+1)]
for i in range(1,n+1):
  mu[i][i] = x[i]
  for j in range(i+1,n+1):
    mu[i][j] = (x[j] +(j-i)*mu[i][j-1])/(j-i+1)


d = [[None for i in range(n+1)] for j in range(n+1)]
for i in range(1,n+1):
  d[i][i] = 0
  for j in range(i+1,n+1):
    d[i][j] = d[i][j-1]+(j-i)/(j-i+1)*(x[j]-mu[i][j-1])**2

ans = findmin(k,1)
print(ans+n*(s/2)**2)

#D = [[0 for i in range(k+1)] for j in range(n+1)]
#for i in range(1,n+1):
#  D[i][1] = d[1][i]
#
#for m in range(2,k+1):
#  for i in range(1,n+1):
#    min = 1e10
#    for j in range(m,i+1):
#      t = D[j-1][m-1]+d[j][i]
#      if t < min:
#        min = t
#    D[i][m] = min
#
#
#print(D[n][k]+n*(s/2)**2)
