/**
 * This submission has complexity O(n^3 log(max(a_i)))
 *
 * @author Finn Lidbetter
 */
val EXP_MAX = 100

fun main(args: Array<String>) {
    val n = readLine()!!.toInt()
    val arr = readLine()!!.split(" ").map{ it -> it.toLong() }
    var exps = IntArray(n)
    for ((index, value) in arr.withIndex()) {
        var exp = 0
        var curr = value
        while (curr > 1) {
            curr = curr shr 1
            exp++
        }
        exps[index] = exp
    }
    // dp[i][j][k] is True iff interval [i,j] can be made equal to 2^k.
    var dp = Array(n) {
        Array(n) {
            BooleanArray(EXP_MAX + 1)
        }
    }
    var bestExp = -1
    for (i in 0..n-1) {
        dp[i][i][exps[i]] = true
        if (exps[i] > bestExp) {
            bestExp = exps[i]
        }
    }
    for (k in 0..EXP_MAX) {
        for (len in 0..n-1) {
            for (i in 0..n-1) {
                val j = i + len
                if (j > n-1) {
                    break
                }
                if (i < j) {
                    dp[i][j][k] = dp[i][j][k] || dp[i + 1][j][k] || dp[i][j-1][k]
                }
                if (dp[i][j][k]) {
                    if (k > bestExp) {
                        bestExp = k
                    }
                    continue
                }
                if (k > 0) {
                    for (m in i..j-1) {
                        dp[i][j][k] = dp[i][j][k] || (dp[i][m][k-1] && dp[m+1][j][k-1])
                        if (dp[i][j][k]) {
                            if (k > bestExp) {
                                bestExp = k
                            }
                            break
                        }
                    }
                }
            }
        }
    }
    println(1L shl(bestExp))
}
