import java.io.*;
import java.util.*;

public class all_sensor_range {
    public static void main(String[] args) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String[] s = br.readLine().split(" ");
        int numTrees = Integer.parseInt(s[0]);
        int numDataPoints = Integer.parseInt(s[1]);
        int rMax = Integer.parseInt(s[2]);
        int[] xVals = new int[numTrees];
        int[] yVals = new int[numTrees];
        HashSet<Position> trees = new HashSet<Position>();
        for (int i=0; i<numTrees; i++) {
            s = br.readLine().split(" ");
            int x = Integer.parseInt(s[0]);
            int y = Integer.parseInt(s[1]);
            xVals[i] = x;
            yVals[i] = y;
            trees.add(new Position(x, y));
        }
        int[] dx = new int[numDataPoints];
        int[] dy = new int[numDataPoints];
        for (int i=0; i<numDataPoints; i++) {
            s = br.readLine().split(" ");
            int x = Integer.parseInt(s[0]);
            int y = Integer.parseInt(s[1]);
            dx[i] = x;
            dy[i] = y;
            if (x==0 && y==0) {
                System.out.println("Impossible");
                return;
            }
        }
        boolean ambiguous = false;
        Position solution = null;
        for (Position treePosition: trees) {
            for (int i=0; i<4; i++) {
                Position candidate = rotatedOffset(treePosition, dx[0], dy[0], i);
                HashSet<Position> expected = new HashSet<>();
                for (int j=0; j<numDataPoints; j++) {
                    expected.add(rotatedOffset(candidate, -dx[j], -dy[j], i));
                }
                boolean valid = true;
                for (int dr=-rMax; dr<=rMax; dr++) {
                    for (int dc=-(rMax - (int)Math.abs(dr)); dc<=rMax - (int)Math.abs(dr); dc++) {
                        Position p = new Position(candidate.x + dc, candidate.y + dr);
                        if (trees.contains(p)) {
                            if (!expected.contains(p)) {
                                valid = false;
                                break;
                            }
                        } else {
                            if (expected.contains(p)) {
                                valid = false;
                                break;
                            }
                        }
                    }
                    if (!valid) {
                        break;
                    }
                }
                if (valid) {
                    if (solution == null) {
                        solution = candidate;
                    } else {
                        ambiguous = true;
                        break;
                    }
                }
            }
            if (ambiguous) {
                break;
            }
        }
        if (ambiguous) {
            System.out.println("Ambiguous");
        } else if (solution == null) {
            System.out.println("Impossible");
        } else {
            System.out.println(solution.x + " " + solution.y);
        }
    }
    static Position rotatedOffset(Position p, int dx, int dy, int rotation) {
        if (rotation == 0) {
            return new Position(p.x + dx, p.y + dy);
        } else if (rotation == 1) {
            return new Position(p.x + dy, p.y - dx);
        } else if (rotation == 2) {
            return new Position(p.x - dx, p.y - dy);
        } else {
            return new Position(p.x - dy, p.y + dx);
        }
    }
}
class Position {
    int x,y;
    public Position(int xx, int yy) {
        x = xx;
        y = yy;
    }
    public boolean equals(Object obj) {
        Position t2 = (Position) obj;
        return x == t2.x && y == t2.y;
    }
    public int hashCode() {
        return Objects.hash(x, y);
    }
}