#!/usr/bin/python3

"""
This implementation is not an intended solution, it is included
primarily for verification purposes. It takes advantage of the
following properties:
1. For an alphabet of size 2, e.g., {0,1}, x is a subword of every
   y-bordered word iff x is a subword of each of y000y, y001y, y010y, ..., y111y
2. For an alphabet of size 3, e.g., {0,1,2} or more, x is a subword
   of every y-bordered word iff x is a subword of y0y, y1y, and y2y.
   This implies, that such an x must be a subword of y.
"""

from sys import stdin


def main():
    line = stdin.readline()
    num_cases = int(line)
    for test_case in range(num_cases):
        tokens = stdin.readline().strip().split(' ')
        alphabet = tokens[0]
        bob_word = tokens[1]
        carol_word = tokens[2]
        good = False
        if len(alphabet) == 1:
            good = True
        elif len(alphabet) == 2:
            middles = [f'{i:03b}' for i in range(8)]
            middles = [
                word.replace('0', alphabet[0]).replace('1', alphabet[1])
                for word in middles
            ]
            carol_between_bobs = True
            bob_between_carols = True
            for middle in middles:
                # if carol_word not in bob_word + middle + bob_word:
                if kmp(bob_word + middle + bob_word, carol_word) == 0:
                    carol_between_bobs = False
                # if bob_word not in carol_word + middle + carol_word:
                if kmp(carol_word + middle + carol_word, bob_word) == 0:
                    bob_between_carols = False
                if not carol_between_bobs and not bob_between_carols:
                    break
            good = carol_between_bobs or bob_between_carols
        else:
            if kmp(bob_word, carol_word) > 0 or kmp(carol_word, bob_word) > 0:
                good = True
            else:
                good = False
        print(1 if good else 0)


def kmp(txt, pat):
    m = len(pat)
    n = len(txt)
    i = 0
    j = 0
    count = 0
    arr = kmp_helper(pat, m)
    while i < n:
        if pat[j] == txt[i]:
            j += 1
            i += 1
        if j == m:
            count += 1
            j = arr[j-1]
        elif i < n and pat[j] != txt[i]:
            if j != 0:
                j = arr[j-1]
            else:
                i = i+1
    return count


def kmp_helper(pat, m):
    arr = [0] * m
    len_val = 0
    for i in range(1, m):
        if pat[i] == pat[len_val]:
            len_val += 1
            arr[i] = len_val
            i += 1
        else:
            if len_val > 0:
                len_val = arr[len_val-1]
            else:
                i += 1
    return arr


if __name__ == '__main__':
    main()
