# Program to generate data for "ISBN Conversion"

# For each pair (c10, c13), where c10 is an ISBN-10 checksum digit and
# c13 is an ISBN-13 checksum digit, make a valid ISBN-10 with checksum
# digit c10 that generates an ISBN-13 with checksum digit c13

import random

# Argument is a valid ISBN-10 in the form of a length-10 list
# of integers, each of which is in the interval [0,9], except
# the last, which is in the interval [0,10].
# Output is the checksum digit of the corresponding ISBN-13.
def compute_isbn13_checksum(isbn10):
    # prepend 978 and remove ISBN-10 checksum digit
    isbn12 = [9, 7, 8] + isbn10[:-1]
    coeff = 1
    summ = 0
    for i in range(len(isbn12)):
        summ += coeff * isbn12[i]
        coeff = (4 - coeff)
    return (10 - summ % 10) % 10

# Randomly add up to 3 hyphens to an ISBN-10
# (if 3 hyphens, one must be immediately before checksum digit)
def add_hyphens(isbn10_str):
    num_hyphens = random.randint(0, 3)
    if num_hyphens == 0:
        result = isbn10_str
    elif num_hyphens == 1:
        before_pos = random.randint(1, 9)
        result = isbn10_str[:before_pos] + '-' + isbn10_str[before_pos:]
    elif num_hyphens == 2:
        before_options = [1,2,3,4,5,6,7,8,9]
        before_pos1 = random.choice(before_options)
        before_options.remove(before_pos1)
        before_pos2 = random.choice(before_options)
        if before_pos2 < before_pos1:
            temp = before_pos1
            before_pos1 = before_pos2
            before_pos2 = temp
        result = isbn10_str[:before_pos1] + '-' + isbn10_str[before_pos1:before_pos2] + '-' + isbn10_str[before_pos2:]
    elif num_hyphens == 3:
        before_options = [1,2,3,4,5,6,7,8]
        before_pos1 = random.choice(before_options)
        before_options.remove(before_pos1)
        before_pos2 = random.choice(before_options)
        if before_pos2 < before_pos1:
            temp = before_pos1
            before_pos1 = before_pos2
            before_pos2 = temp
        result = isbn10_str[:before_pos1] + '-' + isbn10_str[before_pos1:before_pos2] + '-' + isbn10_str[before_pos2:9] + '-' + isbn10_str[9]
    return result


# top-level code
for isbn10_checksum in range(0, 11):
    print('\nStarting isbn10_checksum = ' + str(isbn10_checksum))
    isbn13_found = [False]*10   # one for each ISBN-13 checksum digit
    isbn13_count = 0
    while isbn13_count < 10:
        isbn10 = [None]*10
        isbn10[9] = isbn10_checksum
        summ = isbn10_checksum

        # randomly fill first 8 positions
        for i in range(8):
            isbn10[i] = random.randint(0, 9)
            summ += (10 - i) * isbn10[i]

        # try to fill second-last position (use the fact that
        # the coefficient is 2)
        term_needed = (11 - summ % 11) % 11
        if term_needed % 2 == 0:
            isbn10[8] = term_needed // 2
        elif term_needed < 9:
            isbn10[8] = (term_needed + 11) // 2
        else:
            continue

        isbn13_checksum = compute_isbn13_checksum(isbn10)
        if not isbn13_found[isbn13_checksum]:
            isbn10_str = ''.join([str(digit) for digit in isbn10[:-1]]) + ('X' if isbn10[9] == 10 else str(isbn10[9]))
            isbn10_str = add_hyphens(isbn10_str)
            isbn13_str = '978-' + isbn10_str[:-1] + str(isbn13_checksum)
            isbn13_found[isbn13_checksum] = True
            isbn13_count += 1
            # print('    Success! --> isbn13_checksum = ' + str(isbn13_checksum))
            # print('    ' + isbn10_str + ' -> ' + isbn13_str)
            print(isbn10_str)

