import java.util.Scanner;

public class Pearls_JPB_Faster {

	public static String necklace;
	public static int[] layout;
	public static char[] moves = {'E', 'N', 'S', 'W'};
	public static int[][] visited;
	
	public static void main(String[] args)
	{
		Scanner in = new Scanner(System.in);
		int k = in.nextInt();
		int rows = in.nextInt();
		int cols = in.nextInt();
		necklace = in.next();
		String tmp = necklace+necklace;
		if (tmp.indexOf("BB") != -1 || tmp.indexOf("WWW") != -1) {	// check for impossible string
			System.out.println("impossible");
			System.exit(0);
		}

/***** ADDED BY RSR ****/
                if (k%2 > 0) {// check for odd-length string
			System.out.println("impossible");
			System.exit(0);
		}
		necklace += necklace.charAt(0);				// needed for last check in found()
		int r = in.nextInt();
		int c = in.nextInt();
		layout = new int[k];
		visited = new int[rows+1][cols+1];
		for(int i=1; i<=rows; i++)
			for(int j=1; j<=cols; j++)
				visited[i][j] = -1;
		for(int i=0; i<k; i++)
			layout[i] = -1;
		
		boolean foundLayout = false;
		visited[r][c] = 0;
		for(int dir=0; dir<4; dir++) {
			int nextr = nextRow(r, dir);				
			int nextc = nextCol(c, dir);
			if (nextr < 1 || nextr > rows || nextc < 1 || nextc > cols)
				continue;									// can't go off board
			layout[0] = dir;
			if (found(1, nextr, nextc, r, c, rows, cols)) {
				foundLayout = true;
				break;
			}
		}
		if (foundLayout) {
			for(int i=0; i<k; i++) {
				System.out.print(moves[layout[i]]);
			}
			System.out.println();
		}
		else
			System.out.println("impossible");

	}
	
	public static boolean found(int index, int currr, int currc, int endr, int endc, int rows, int cols)
	{
/*
System.out.print("index, location: " + index + " " + currr + "," + currc + " ");
for(int i=0; i<index; i++) System.out.print(moves[layout[i]]);
System.out.println();
/**/

		if (index == necklace.length()-1) {
			return (currr == endr && currc == endc && okDir(layout[0],index));
		}

/******* ADDED BY RSR ******/
    if (Math.abs(currr - endr)+Math.abs(currc - endc) > necklace.length()-index)
      return false;


		if (visited[currr][currc] != -1)
			return false;
		visited[currr][currc] = index;
		for(int dir=0; dir<4; dir++) {
			if (prevSq(layout[index-1], dir))
				continue;									// can't go back to previous square
			int nextr = nextRow(currr, dir);				
			int nextc = nextCol(currc, dir);
//System.out.println("  Trying direction " + dir + ", next = " + nextr + "," + nextc);
			if (nextr < 1 || nextr > rows || nextc < 1 || nextc > cols)
				continue;									// can't go off board
//System.out.println("    Trying direction " + dir + ",necklace = " + necklace.charAt(index) + ", okDir = " + okDir(dir, index));
			if (okDir(dir, index)) {
				layout[index] = dir;
				if (found(index+1, nextr, nextc, endr, endc, rows, cols))
					return true;
			}
		}
		visited[currr][currc] = -1;
		return false;
	}

	public static int nextRow(int r, int move)
	{
		switch (move) {
			case 2 : return r+1;
			case 1 : return r-1;
			default : return r;
		}
	}
	
	public static int nextCol(int c, int move)
	{
		switch (move) {
			case 3 : return c-1;
			case 0 : return c+1;
			default : return c;
		}
	}

	public static boolean okDir(int d, int index)
	{
		char ch = necklace.charAt(index);
//if (index == 4) System.out.println("    in okDir, ch = " + ch + ", turn = " + turn(d, layout[index-1]) + ", prev = " + necklace.charAt(index-1));
		if (ch == 'B') {
			if (index > 1 && layout[index-1] != layout[index-2]) // must go straight into a B
				return false;
			if (!turn(d, layout[index-1]))			// must turn at B
				return false;
		}
		else if (ch == 'W') {
			if (d != layout[index-1])				// must go through at W
				return false;
		}
		ch = necklace.charAt(index-1);
		if (ch == 'B') {
			if (d != layout[index-1])				// must go straight after B
				return false;
		}
		else if (ch == 'W') {
			if (index>2 && layout[index-3] == layout[index-1])
				if (!turn(d, layout[index-1]))
					return false;
		}
		return true;
	}
	
	public static boolean turn(int d1, int d2)
	{
		if (d1 == 0 || d1 == 3)
			return d2 == 1 || d2 == 2;
		else
			return d2 == 0 || d2 == 3;
	}
	
	public static boolean prevSq(int d1, int d2)
	{
		switch (d1) {
		case 0 : return (d2 == 3);
		case 1 : return (d2 == 2);
		case 2 : return (d2 == 1);
		default : return (d2 == 0);
		}
	}
}
