#!/usr/bin/env python3
import sys
import re

line = sys.stdin.readline()
# CHECK FOR EXTRA WHITE SPACE:
if line[:-1] != line.strip() or  "  " in line or "\t" in line: sys.exit(39)

# CHECK FOR CORRECT NUMBER OF ARGS:
line = line.split()
if len(line) != 3: sys.exit(38)

# CHECK FOR LEADING ZEROS:
[ks,ns,ms] = line
[k,n,m] = list(map(int,[ks,ns,ms])) # NEED TO CHECK FOR ints BEFORE mapping?
if list(map(str,[k,n,m])) != [ks,ns,ms]: sys.exit(37)

# CHECK BOUNDS:
if k < 5 or k > 60: sys.exit(43)
if n < 5 or n > 50: sys.exit(44)
if m < 5 or m > 50: sys.exit(45)

# CHECK FOR EXTRA WHITE SPACE:
s = sys.stdin.readline()
if s[:-1] != s.strip(): sys.exit(36)
s = s.strip()

# CHECK STRING LENGTH:
if len(s) != k: sys.exit(46)

# IF WE WANT TO DISALLOW BB OR WWW:
#bb = re.search("BB",s)
#if bb != None: sys.exit(40)
#www= re.search("WWW",s)
#if www != None: sys.exit(41)

line = sys.stdin.readline()

# CHECK FOR EXTRA WHITE SPACE:
if line[:-1] != line.strip() or  "  " in line or "\t" in line: sys.exit(35)

# CHECK FOR CORRECT NUMBER OF ARGS:
line = line.split()
if len(line) != 2: sys.exit(34)

# CHECK FOR LEADING ZEROS:
[rs,cs] = line
[r,c] = list(map(int,[rs,cs])) # NEED TO CHECK FOR ints BEFORE mapping?
if list(map(str,[r,c])) != [rs,cs]: sys.exit(33)

# CHECK FOR JUNK AT END OF FILE:
if sys.stdin.readline():
  sys.exit(32)

# CHECK BOUNDS ON STARTING LOCATION:
if r < 1 or r > n or c < 1 or c > m: sys.exit(47)

# CHECK BEAD COUNTS (# beads >= k/2; #B >= 2* #W)
count = [0,0,0]
for ch in s:
  if ch=='W': count[0]+=1
  elif ch=='B': count[1]+=1
  elif ch=='.': count[2]+=1
  else: sys.exit(48)
if count[0]+count[1] < len(s)/2: sys.exit(49)
if count[1]<2*count[0]: sys.exit(50)

# MAKE SURE NO MORE THAN FIVE DOTS IN A ROW:
if s.find("......") >= 0: sys.exit(51)

# ALL CHECKS PASS:
sys.exit(42)
