import java.util.*;

public class WalkZackSimOnly {

    public static void main(String[] args) {
	Scanner in = new Scanner(System.in);
	int m,n;
	m = in.nextInt();
	n = in.nextInt();
	int[][] inters = new int[m][6]; // x, y, N, E, S, W
	for (int i = 0; i < m; i++) {
	    inters[i][0] = in.nextInt();
	    inters[i][1] = in.nextInt();
	    inters[i][2] = -1;
	    inters[i][3] = -1;
	    inters[i][4] = -1;
	    inters[i][5] = -1;
	}
	int[][] edges = new int[n][3];
	for (int e = 0; e < n; e++) {
	    int v1 = in.nextInt()-1;
	    int v2 = in.nextInt()-1;
	    edges[e][0] = Math.min(v1,v2);
	    edges[e][1] = Math.max(v1,v2);	    
	    edges[e][2] = in.nextInt();
	    // v2 relative to v1
	    if (inters[v1][0] == inters[v2][0]) {
		if (inters[v1][1] > inters[v2][1]) {
		    // v1 N of v2, v2 S of v1
		    inters[v1][4] = e;
		    inters[v2][2] = e;
		} else {
		    inters[v1][2] = e;
		    inters[v2][4] = e;
		}
	    } else if (inters[v1][0] > inters[v2][0]) {
		// v1 E of v2, v2 W of v1
		inters[v1][5] = e;
		inters[v2][3] = e;
	    } else {
		inters[v1][3] = e;
		inters[v2][5] = e;
	    }
	}

	//for (int v = 0; v < m; v++) 
	//    System.out.println(inters[v][2]+" "+inters[v][3]+" "+inters[v][4]+" "+inters[v][5]);

	int cv = in.nextInt()-1;
	String cds = in.next();
	int cd = -1;
	switch (cds) {
	case "N": cd = 2; break;
	case "E": cd = 3; break;
	case "S": cd = 4; break;
	case "W": cd = 5; break;
	}
	// the above will work with the given input, which is easier...
	// if we are instead doing starting point + starting direction then
	// we also need to:
	int firste = inters[cv][cd];
	int v2 = -1;
	if (edges[firste][0] == cv) v2 = edges[firste][1];
	else v2 = edges[firste][0];
	edges[firste][2]--;
	// remove edge if necessary
	if (edges[firste][2] == 0) {
	    inters[cv][cd] = -1;
	    int oppd = cd+2; if (oppd > 5) oppd -= 4;
	    inters[v2][oppd] = -1;
	}
	// cv = other end of this edge
	cv = v2;

	while(true) {
	    int ne = 0;
	    int around = cd+2; if (around > 5) around -= 4;
	    for (int d = 2; d < 6; d++) {
		if (d != around && inters[cv][d] != -1) ne++;
	    }
	    //System.out.println(cv+" dir "+cd+" "+ne+" outlets");
	    if (ne == 0) {
		System.out.println(inters[cv][0]+" "+inters[cv][1]);
		System.exit(0);
	    }
	    int nextd = -1;
	    if (ne == 3) {
		// three options, middle is same dir as current
		nextd = cd;
	    } else if (ne == 2) {
		// two options, lefter one
		switch(cd) {
		case 2: // heading N, W if possible else N
		    nextd = (inters[cv][5] != -1 ? 5 : 2); break;
		case 3: // heading E, N if possible else E
		    nextd = (inters[cv][2] != -1 ? 2 : 3); break;
		case 4: // heading S, E if possible else S
		    nextd = (inters[cv][3] != -1 ? 3 : 4); break;
		case 5: // heading W, S if possible else W
		    nextd = (inters[cv][4] != -1 ? 4 : 5); break;
		} 
	    } else {
		// one option, find it
		for (int d = 2; d < 6; d++)
		    if (d != around && inters[cv][d] != -1) nextd = d;
	    }
	    int oppd = nextd+2; if (oppd > 5) oppd -= 4;
	    int nexte = inters[cv][nextd];
	    // update interest, remove edge if zero, move to next vertex
	    int nextv = -1;
	    if (edges[nexte][0] == cv) nextv = edges[nexte][1];
	    else nextv = edges[nexte][0];
	    edges[nexte][2]--;
	    //System.out.println("nextd " + nextd + " nexte " + nexte + " now " + edges[nexte][2]);
	    if (edges[nexte][2] < 0) System.exit(-1);
	    if (edges[nexte][2] == 0) {
		// cv, cd and nextv, oppd disappear
		//System.out.println("killing "+nexte + ": " +cv+"/"+nextd + " , "+nextv+"/"+oppd);
		inters[cv][nextd] = -1;
		inters[nextv][oppd] = -1;
	    }
	    cv = nextv;
	    cd = nextd;
	}
    }
}
