#include <bits/stdc++.h>
using namespace std;

vector<int> ScanIntergersLine(int n_ints = -1) {
  string s;
  getline(cin, s);
  size_t now = 0, t;
  vector<int> ret;
  do {
    t = s.find_first_of(' ', now);
    if (t == string::npos) {
      t = s.size() - now;
    } else {
      t -= now;
    }
    string token = s.substr(now, t);
    now += t + 1;
    ret.push_back(stoi(token));
  } while (now < s.size());
  assert(n_ints == -1 || n_ints == ret.size());
  return ret;
}

int nbr[2505][4];
int get_direction(int ux, int uy, int vx, int vy) {
  if(ux==vx) {
    if (uy < vy) return 0; // north
    else return 2; // south
  } else {
    if (ux < vx) return 3; // east
    else return 1; // west
  }
}
int main() {
  auto ns = ScanIntergersLine(2);
  int n = ns[0];
  int m = ns[1];
  assert(2 <= n && n <= 2500);
  auto xs = ScanIntergersLine(2*n);
  const int MAXCOORD = 1e6;
  const int MAXWEIGHT = 1e6;
  unordered_map<int, vector<int>> x_chain, y_chain;
  for (int i = 0; i < 2*n; i += 2) {
    int x = xs[i], y = xs[i+1];
    assert(x >= 0 && x <= MAXCOORD);
    assert(y >= 0 && y <= MAXCOORD);
    x_chain[x].push_back(y);
    y_chain[y].push_back(x);
  }
  for (auto& it : x_chain) sort(it.second.begin(), it.second.end());
  for (auto& it : y_chain) sort(it.second.begin(), it.second.end());
  
  for (int i = 0; i < m; i++) {
    auto e = ScanIntergersLine(3);
    int u = e[0], v = e[1], w = e[2];
    assert(u >= 1 && u <= n);
    assert(v >= 1 && v <= n);
    assert(w >= 1 && w <= MAXWEIGHT);
    int ux = xs[u*2-2], uy = xs[u*2-1], vx = xs[v*2-2], vy = xs[v*2-1];
    assert(((ux == vx) ^ (uy == vy)) != 0);
    if (ux == vx) {
      int t = min(uy, vy);
      auto& chain = x_chain[ux];
      auto it = upper_bound(chain.begin(), chain.end(), t);
      assert(it != chain.end() && *it == max(uy, vy));
    } else { // uy == vy
      int t = min(ux, vx);
      auto& chain = y_chain[uy];
      auto it = upper_bound(chain.begin(), chain.end(), t);
      assert(it != chain.end() && *it == max(ux, vx));
    }
    nbr[u][get_direction(ux, uy, vx, vy)] = v;
    nbr[v][get_direction(vx, vy, ux, uy)] = u;
  }
  string s;
  getline(cin, s);
  auto t = s.find_first_of(' ');
  int start = stoi(s.substr(0, t));
  char dir = s[t+1];
  assert(dir == 'N' || dir == 'E' || dir == 'W' || dir == 'S');
  assert(t+2 == s.size());
  assert(1 <= start && start <= n);

  // Check if the starting direction is allowed.
  assert(dir != 'N' || nbr[start][0] > 0);
  assert(dir != 'W' || nbr[start][1] > 0);
  assert(dir != 'S' || nbr[start][2] > 0);
  assert(dir != 'E' || nbr[start][3] > 0);
  cin >> s;
  assert(cin.eof());
  exit(42);
}