﻿namespace MusicStore.Test.Routing
{
    using MusicStore.Controllers;
    using MusicStore.Models;
    using MyTested.AspNetCore.Mvc;
    using Xunit;

    public class AccountRouteTest
    {
        [Fact]
        public void PostLoginActionShouldBeRoutedSuccessfuly()
            => MyRouting
                .Configuration()
                .ShouldMap(request => request
                    .WithMethod(HttpMethod.Post)
                    .WithLocation("/Account/Login?returnUrl=Test")
                    .WithFormFields(new
                    {
                        Email = "test@test.com",
                        Password = "123456",
                        RememberMe = "true"
                    })
                    .WithAntiForgeryToken())
                .To<AccountController>(c => c.Login(
                    new LoginViewModel
                    {
                        Email = "test@test.com",
                        Password = "123456",
                        RememberMe = true
                    },
                    "Test"));
    }
}
