﻿namespace MusicStore.Test.Routing
{
    using Microsoft.Extensions.Caching.Memory;
    using MusicStore.Controllers;
    using MusicStore.Models;
    using MyTested.AspNetCore.Mvc;
    using System.Threading;
    using Xunit;

    public class HomeRouteTest
    {
        [Fact]
        public void GetErrorActionShouldBeRoutedSuccessfuly()
           => MyRouting
               .Configuration()
               .ShouldMap("/Home/Error")
               .To<HomeController>(c => c.Error());

        [Fact]
        public void GetIndexActionShouldBeRoutedSuccessfuly()
            => MyRouting
                .Configuration()
                .ShouldMap("/Home")
                .To<HomeController>(c => c.Index(
                    With.Any<MusicStoreContext>(),
                    With.Any<IMemoryCache>()));
    }
}
