﻿namespace MusicStore.Test
{
    using Microsoft.AspNetCore.Hosting;
    using Microsoft.AspNetCore.Identity;
    using Microsoft.Extensions.Caching.Memory;
    using Microsoft.Extensions.DependencyInjection;
    using Microsoft.Extensions.Options;
    using Moq;
    using MusicStore.Models;
    using MusicStore.Test.Mocks;
    using MyTested.AspNetCore.Mvc;

    public class TestStartup : Startup
    {
        public TestStartup(IHostingEnvironment hostingEnvironment)
            : base(hostingEnvironment)
        {
        }

        public void ConfigureTestServices(IServiceCollection services)
        {
            base.ConfigureServices(services);

            services.ReplaceSingleton<SignInManager<ApplicationUser>>(sp =>
                MockProvider.SignInManager(sp.GetRequiredService<UserManager<ApplicationUser>>()));

            // Using the our custom version of the SignManager mock
            // services.ReplaceSingleton<SignInManager<ApplicationUser>, SignInManagerMock>();
        }
    }
}