﻿namespace MusicStore.Test.ViewComponents
{
    using MusicStore.Components;
    using MusicStore.Test.Data;
    using MyTested.AspNetCore.Mvc;
    using Xunit;

    public class CartSummaryComponentTest
    {
        [Fact]
        public void InvokingTheComponentShouldReturnCorrectCartItems()
            => MyViewComponent<CartSummaryComponent>
                .Instance()
                .WithSession(session => session
                    .WithEntry("Session", "TestCart"))
                .WithData(CartItemData.GetMany("TestCart", "TestAlbum"))
                .InvokedWith(vc => vc.InvokeAsync())
                .ShouldHave()
                .ViewBag(viewBag => viewBag
                    .ContainingEntries(new
                    {
                        CartCount = 10,
                        CartSummary = "TestAlbum"
                    }))
                .AndAlso()
                .ShouldReturn()
                .View();
    }
}
