﻿namespace MusicStore.Test.Controllers
{
    using MusicStore.Controllers;
    using MusicStore.Models;
    using MyTested.AspNetCore.Mvc;
    using Xunit;

    public class ManageControllerTest
    {
        [Fact]
        public void RemoveLoginShouldReturnRedirectToActionWithNoUser()
            => MyController<ManageController>
                .Instance()
                .Calling(c => c.RemoveLogin(With.No<string>(), With.No<string>()))
                .ShouldReturn()
                .Redirect(result => result
                    .To<ManageController>(c => c
                        .ManageLogins(ManageController.ManageMessageId.Error)));

        [Fact]
        public void ChangePasswordShouldReturnViewWithSameModelWithInvalidModelState()
        {
            var model = new ChangePasswordViewModel();

            MyController<ManageController>
                .Instance()
                .Calling(c => c.ChangePassword(model))
                .ShouldHave()
                .ModelState(modelState => modelState
                    .For<ChangePasswordViewModel>()
                    .ContainingErrorFor(m => m.OldPassword)
                    .ThatEquals("The Current password field is required.")
                    .AndAlso()
                    .ContainingErrorFor(m => m.NewPassword)
                    .ThatEquals("The New password field is required.")
                    .AndAlso()
                    .ContainingNoErrorFor(m => m.ConfirmPassword))
                .AndAlso()
                .ShouldReturn()
                .View(result => result
                    .WithModelOfType<ChangePasswordViewModel>()
                    .Passing(viewModel => viewModel == model));
        }
    }
}
