﻿namespace MusicStore.Test.Controllers
{
    using Microsoft.Extensions.Options;
    using Moq;
    using MusicStore.Controllers;
    using MusicStore.Models;
    using MusicStore.Test.Mocks;
    using MyTested.AspNetCore.Mvc;
    using System.Collections.Generic;
    using Xunit;

    public class StoreControllerTest
    {
        [Fact]
        public void IndexShouldReturnViewWithGenres()
            => MyController<StoreController>
                .Instance()
                .WithData(
                    new Genre { Name = "FirstGenre" },
                    new Genre { Name = "SecondGenre" })
                .Calling(c => c.Index())
                .ShouldReturn()
                .View(result => result
                    .WithModelOfType<List<Genre>>()
                    .Passing(model => model.Count == 2));
        [Fact]
        public void BrowseShouldReturnNotFoundWithInvalidGenre()
            => MyController<StoreController>
                .Instance(new StoreController(
                    MockProvider.MusicStoreContext,
                    Mock.Of<IOptions<AppSettings>>()))
                .Calling(c => c.Browse("Invalid"))
                .ShouldReturn()
                .NotFound();

        [Fact]
        public void BrowseShouldReturnCorrectViewModelWithValidGenre()
            => MyController<StoreController>
                .Instance()
                .WithDependencies(
                    MockProvider.MusicStoreContext,
                    From.Services<IOptions<AppSettings>>())
                .Calling(c => c.Browse("Rap"))
                .ShouldReturn()
                .View(result => result
                    .WithModelOfType<Genre>()
                    .Passing(model => model.GenreId == 2));
    }
}
