﻿namespace MusicStore.Test.Data
{
    using MusicStore.Models;
    using System.Collections.Generic;
    using System.Linq;

    public class CartItemData
    {
        public static IEnumerable<CartItem> GetMany(string cartId, string albumTitle)
        {
            var album = new Album { AlbumId = 1, Title = albumTitle };

            return Enumerable
                .Range(1, 10)
                .Select(n => new CartItem
                {
                    AlbumId = 1,
                    Album = album,
                    Count = 1,
                    CartId = cartId,
                });
        }
    }
}
