﻿namespace MusicStore.Test.Extensions
{
    using MyTested.AspNetCore.Mvc.Builders.Base;
    using MyTested.AspNetCore.Mvc.Builders.Contracts.Base;
    using MyTested.AspNetCore.Mvc.Exceptions;
    using MyTested.AspNetCore.Mvc.Utilities;
    using MyTested.AspNetCore.Mvc.Utilities.Extensions;
    using System;
    using System.Collections.Generic;

    public static class ResponseModelExtensions
    {
        public static IBaseTestBuilderWithComponent WithCollectionModelOfType<TModel>(
            // base test builder we are extending
            this IBaseTestBuilderWithResponseModel builder,
            // optional predicate the model should pass
            Func<ICollection<TModel>, bool> predicate = null)
        {
            // cast to the actual class behind the interface
            var actualBuilder = (BaseTestBuilderWithResponseModel)builder;
            // helper method validating the model type
            var modelCollection = actualBuilder.GetActualModel<ICollection<TModel>>();

            // execute the predicate if exists
            if (predicate != null && !predicate(modelCollection))
            {
                // get the current test context
                var testContext = actualBuilder.TestContext;

                // throw exception for invalid predicate
                throw new ResponseModelAssertionException(string.Format(
                    "When calling {0} in {1} expected response model collection of {2} to pass the given predicate, but it failed.",
                    testContext.MethodName,
                    testContext.Component.GetName(),
                    typeof(TModel).ToFriendlyTypeName()));
            }

            // return the same test builder
            return actualBuilder;
        }
    }
}
