﻿namespace MusicStore.Test.Mocks
{
    using Microsoft.AspNetCore.Authentication;
    using Microsoft.AspNetCore.Http;
    using Microsoft.AspNetCore.Identity;
    using Microsoft.EntityFrameworkCore;
    using Microsoft.Extensions.Caching.Memory;
    using Microsoft.Extensions.DependencyInjection;
    using Microsoft.Extensions.Options;
    using Models;
    using Moq;
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    public static class MockProvider
    {
        public static IMemoryCache ThrowableMemoryCache
        {
            get
            {
                var memoryCacheMock = new Mock<IMemoryCache>();

                memoryCacheMock
                    .Setup(c => c.CreateEntry(
                        It.Is<string>(k => k == $"album_{int.MaxValue}")))
                    .Throws(new InvalidOperationException("Caching is not available for this test."));

                return memoryCacheMock.Object;
            }
        }

        public static MusicStoreContext MusicStoreContext
        {
            get
            {
                var efServiceProvider = new ServiceCollection()
                    .AddEntityFrameworkInMemoryDatabase()
                    .BuildServiceProvider();

                var serviceProvider = new ServiceCollection()
                    .AddDbContext<MusicStoreContext>(db => db
                        .UseInMemoryDatabase(databaseName: "TestDB")
                        .UseInternalServiceProvider(efServiceProvider))
                    .BuildServiceProvider();

                var dbContext = serviceProvider.GetRequiredService<MusicStoreContext>();

                dbContext.AddRange(new List<Genre>
                {
                    new Genre { GenreId = 1, Name = "Pop" },
                    new Genre { GenreId = 2, Name = "Rap" },
                    new Genre { GenreId = 3, Name = "Rock" }
                });

                dbContext.SaveChanges();

                return dbContext;
            }
        }

        public static SignInManager<ApplicationUser> SignInManager(UserManager<ApplicationUser> userManager)
        {
            var signInManagerMock = new Mock<SignInManager<ApplicationUser>>(
                userManager,
                Mock.Of<IHttpContextAccessor>(),
                Mock.Of<IUserClaimsPrincipalFactory<ApplicationUser>>(),
                Mock.Of<IOptions<IdentityOptions>>(),
                null,
                Mock.Of<IAuthenticationSchemeProvider>());

            signInManagerMock
                .Setup(s => s.PasswordSignInAsync(
                    It.IsAny<string>(),
                    It.IsAny<string>(),
                    It.IsAny<bool>(),
                    It.IsAny<bool>()))
                .Returns((string userName, string password, bool isPersistent, bool lockoutOnFailure) =>
                {
                    if (userName == "valid@valid.com" && password == "valid")
                    {
                        return Task.FromResult(SignInResult.Success);
                    }

                    return Task.FromResult(SignInResult.Failed);
                });

            return signInManagerMock.Object;
        }
    }
}
