﻿namespace MusicStore.Test.Mocks
{
    using Microsoft.AspNetCore.Authentication;
    using Microsoft.AspNetCore.Http;
    using Microsoft.AspNetCore.Identity;
    using Microsoft.Extensions.Logging;
    using Microsoft.Extensions.Options;
    using Models;
    using System.Threading.Tasks;

    public class SignInManagerMock : SignInManager<ApplicationUser>
    {
        public SignInManagerMock(
            UserManager<ApplicationUser> userManager,
            IHttpContextAccessor contextAccessor,
            IUserClaimsPrincipalFactory<ApplicationUser> claimsFactory,
            IOptions<IdentityOptions> optionsAccessor,
            ILogger<SignInManager<ApplicationUser>> logger,
            IAuthenticationSchemeProvider authProvider)
            : base(userManager, contextAccessor, claimsFactory, optionsAccessor, logger, authProvider)
        {
        }

        public override Task<SignInResult> PasswordSignInAsync(string userName, string password, bool isPersistent, bool lockoutOnFailure)
        {
            if (userName == "valid@valid.com" && password == "valid")
            {
                return Task.FromResult(SignInResult.Success);
            }

            return Task.FromResult(SignInResult.Failed);
        }
    }
}
