﻿namespace MusicStore.Test.Routing.Admin
{
    using MusicStore.Areas.Admin.Controllers;
    using MyTested.AspNetCore.Mvc;
    using Xunit;

    public class StoreManagerRouteTest
    {
        [Fact]
        public void GetIndexActionShouldBeRoutedSuccessfuly()
            => MyRouting
                .Configuration()
                .ShouldMap(request => request
                    .WithLocation("/Admin/StoreManager")
                    .WithUser(user => user
                        .WithClaim("ManageStore", "Allowed")))
                .To<StoreManagerController>(c => c.Index());
    }
}
