﻿namespace MusicStore.Test.Routing
{
    using MusicStore.Controllers;
    using MyTested.AspNetCore.Mvc;
    using System.Threading;
    using Xunit;

    public class ShoppingCartRouteTest
    {
        [Fact]
        public void GetAddToCartActionShouldBeRoutedSuccessfuly()
            => MyRouting
                .Configuration()
                .ShouldMap("/ShoppingCart/AddToCart/1")
                .To<ShoppingCartController>(c => c.AddToCart(1, CancellationToken.None));


        [Fact]
        public void PostRemoveFromCartActionShouldBeRoutedSuccessfuly()
            => MyRouting
                .Configuration()
                .ShouldMap(request => request
                    .WithMethod(HttpMethod.Post)
                    .WithLocation("/ShoppingCart/RemoveFromCart/1")
                    .WithAntiForgeryToken())
                .To<ShoppingCartController>(c => c.RemoveFromCart(
                    1,
                    With.Any<CancellationToken>()));
    }
}
