/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.VariableVisitor;
import java.util.ArrayList;
import java.util.Collection;

public class Equals {
    private final Expression a;
    private final Expression b;

    public Equals(Expression a, Expression b) {
        this.a = a;
        this.b = b;
    }

    public boolean isEqual() throws ExpressionException {
        VariableVisitor vva = this.a.traverse(new VariableVisitor());
        VariableVisitor vvb = this.b.traverse(new VariableVisitor());
        Collection<Variable> variables = vva.getVariables();
        if (!variables.equals(vvb.getVariables())) {
            return false;
        }
        ArrayList<Variable> vars = new ArrayList<Variable>(variables.size());
        vars.addAll(variables);
        ContextFiller cf = new ContextFiller(vars);
        int count = 1 << vars.size();
        int i = 0;
        while (i < count) {
            cf.setContextTo(i);
            if (this.a.calculate(cf) != this.b.calculate(cf)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

