/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.format;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.format.TruthTableFormatter;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.core.Bits;

public class TruthTableFormatterCSV
implements TruthTableFormatter {
    @Override
    public String format(TruthTable truthTable) throws ExpressionException {
        StringBuilder sb = new StringBuilder();
        for (String n : truthTable.getVarNames()) {
            sb.append(n).append(",");
        }
        for (String n : truthTable.getResultNames()) {
            sb.append(',').append(n);
        }
        sb.append('\n');
        this.export(sb, truthTable);
        return sb.toString();
    }

    private void export(StringBuilder sb, TruthTable truthTable) {
        int vars = truthTable.getVars().size();
        int r = 0;
        while (r < truthTable.getRows()) {
            long m = Bits.up(1L, vars - 1);
            int c = 0;
            while (c < vars) {
                if (((long)r & m) == 0L) {
                    sb.append('0');
                } else {
                    sb.append('1');
                }
                sb.append(',');
                m >>= 1;
                ++c;
            }
            c = 0;
            while (c < truthTable.getResultCount()) {
                ThreeStateValue v = truthTable.getResult(c).get(r);
                sb.append(',').append(v.toString());
                ++c;
            }
            sb.append('\n');
            ++r;
        }
    }
}

