/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.format;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.format.TruthTableFormatter;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.draw.graphics.text.formatter.LaTeXFormatter;

public class TruthTableFormatterLaTeX
implements TruthTableFormatter {
    @Override
    public String format(TruthTable truthTable) throws ExpressionException {
        StringBuilder sb = new StringBuilder();
        sb.append("\\begin{center}\n\\begin{tabular}{");
        for (Variable v : truthTable.getVars()) {
            sb.append("c");
        }
        sb.append("|");
        int i = 0;
        while (i < truthTable.getResultCount()) {
            sb.append("c");
            ++i;
        }
        sb.append("}\n");
        for (Variable v : truthTable.getVars()) {
            sb.append("$").append(LaTeXFormatter.format(v)).append("$&");
        }
        i = 0;
        while (i < truthTable.getResultCount()) {
            sb.append("$").append(LaTeXFormatter.format(new Variable(truthTable.getResultName(i)))).append("$");
            if (i < truthTable.getResultCount() - 1) {
                sb.append("&");
            }
            ++i;
        }
        sb.append("\\\\\n");
        sb.append("\\hline\n");
        ContextFiller cf = new ContextFiller(truthTable.getVars());
        int i2 = 0;
        while (i2 < cf.getRowCount()) {
            cf.setContextTo(i2);
            for (Variable v : cf) {
                sb.append(this.format(cf.get(v))).append("&");
            }
            int j = 0;
            while (j < truthTable.getResultCount()) {
                ThreeStateValue r = truthTable.getResult(j).get(i2);
                sb.append(this.format(r));
                if (j < truthTable.getResultCount() - 1) {
                    sb.append("&");
                }
                ++j;
            }
            sb.append("\\\\\n");
            ++i2;
        }
        sb.append("\\end{tabular}\n\\end{center}\n");
        return sb.toString();
    }

    private String format(boolean b) {
        return this.format(ThreeStateValue.value(b));
    }

    private String format(ThreeStateValue r) {
        switch (r) {
            case one: {
                return "$1$";
            }
            case zero: {
                return "$0$";
            }
            case dontCare: {
                return "-";
            }
        }
        return null;
    }
}

