/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.parser;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.NamedExpression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.parser.ParseException;
import de.neemann.digital.analyse.parser.Tokenizer;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class Parser {
    private final Tokenizer tokenizer;

    public Parser(String expression) {
        this(new StringReader(expression));
    }

    public Parser(Reader reader) {
        this.tokenizer = new Tokenizer(reader);
    }

    public ArrayList<Expression> parse() throws IOException, ParseException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        block4: while (true) {
            list.add(this.parseLet());
            switch (this.tokenizer.next()) {
                case EOF: {
                    return list;
                }
                case COMMA: {
                    continue block4;
                }
            }
            break;
        }
        throw new ParseException(Lang.get("err_parserUnexpectedToken_N", this.tokenizer.toString()));
    }

    private Expression parseLet() throws IOException, ParseException {
        if (this.tokenizer.peek() == Tokenizer.Token.IDENT && this.tokenizer.getIdent().equals("let")) {
            this.tokenizer.consume();
            this.consume(Tokenizer.Token.IDENT);
            String name = this.tokenizer.getIdent();
            this.consume(Tokenizer.Token.EQUAL);
            return new NamedExpression(name, this.parseOr());
        }
        return this.parseOr();
    }

    private Expression parseOr() throws IOException, ParseException {
        Expression ex = this.parseAnd();
        while (this.tokenizer.peek() == Tokenizer.Token.OR || this.tokenizer.peek() == Tokenizer.Token.XOR) {
            ex = this.tokenizer.next() == Tokenizer.Token.OR ? Operation.or(ex, this.parseAnd()) : Operation.xor(ex, this.parseAnd());
        }
        return ex;
    }

    private Expression parseAnd() throws IOException, ParseException {
        Expression ex = this.parseEqual();
        while (true) {
            if (this.tokenizer.peek() == Tokenizer.Token.AND) {
                this.tokenizer.consume();
                ex = Operation.and(ex, this.parseEqual());
                continue;
            }
            if (!this.isSimpleEx(this.tokenizer.peek())) break;
            ex = Operation.and(ex, this.parseEqual());
        }
        return ex;
    }

    private Expression parseEqual() throws IOException, ParseException {
        Expression ex = this.parseSimpleExp();
        while (this.tokenizer.peek() == Tokenizer.Token.EQUAL || this.tokenizer.peek() == Tokenizer.Token.NOTEQUAL) {
            Tokenizer.Token tok = this.tokenizer.next();
            ex = Operation.xor(ex, this.parseSimpleExp());
            if (tok != Tokenizer.Token.EQUAL) continue;
            ex = Not.not(ex);
        }
        return ex;
    }

    private boolean isSimpleEx(Tokenizer.Token tok) {
        return tok == Tokenizer.Token.NOT || tok == Tokenizer.Token.OPEN || tok == Tokenizer.Token.IDENT || tok == Tokenizer.Token.ONE || tok == Tokenizer.Token.ZERO;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Expression parseSimpleExp() throws IOException, ParseException {
        switch (Parser.$SWITCH_TABLE$de$neemann$digital$analyse$parser$Tokenizer$Token()[this.tokenizer.next().ordinal()]) {
            case 5: {
                res /* !! */  = Not.not(this.parseSimpleExp());
                ** GOTO lbl24
            }
            case 7: {
                res /* !! */  = this.parseOr();
                if (this.tokenizer.next() != Tokenizer.Token.CLOSE) {
                    throw new ParseException(Lang.get("err_parserMissingClosedParenthesis", new Object[0]));
                }
                ** GOTO lbl24
            }
            case 2: {
                res /* !! */  = new Variable(this.tokenizer.getIdent());
                ** GOTO lbl24
            }
            case 9: {
                res /* !! */  = Constant.ONE;
                ** GOTO lbl24
            }
            case 10: {
                res /* !! */  = Constant.ZERO;
                if (true) ** GOTO lbl24
            }
            default: {
                throw new ParseException(Lang.get("err_parserUnexpectedToken_N", new Object[]{this.tokenizer.toString()}));
            }
        }
        do {
            this.tokenizer.consume();
            res /* !! */  = Not.not(res /* !! */ );
lbl24:
            // 6 sources

        } while (this.tokenizer.peek() == Tokenizer.Token.POSTNOT);
        return res /* !! */ ;
    }

    private void consume(Tokenizer.Token token) throws IOException, ParseException {
        if (!this.tokenizer.next().equals((Object)token)) {
            throw new ParseException(Lang.get("err_parserUnexpectedToken_N", this.tokenizer.toString()));
        }
    }
}

