/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.parser;

import java.io.IOException;
import java.io.Reader;

public class Tokenizer {
    private final Reader in;
    private final StringBuilder builder;
    private Token token;
    private boolean isToken;
    private boolean isUnreadChar = false;
    private int unreadChar;

    public Tokenizer(Reader in) {
        this.in = in;
        this.token = Token.UNKNOWN;
        this.isToken = false;
        this.builder = new StringBuilder();
    }

    public Token next() throws IOException {
        Token token = this.peek();
        this.consume();
        return token;
    }

    public void consume() {
        this.isToken = false;
    }

    public Token peek() throws IOException {
        int c;
        if (this.isToken) {
            return this.token;
        }
        while (this.isWhiteSpace(c = this.readChar())) {
        }
        switch (c) {
            case -1: {
                this.token = Token.EOF;
                break;
            }
            case 48: {
                this.token = Token.ZERO;
                break;
            }
            case 49: {
                this.token = Token.ONE;
                break;
            }
            case 40: {
                this.token = Token.OPEN;
                break;
            }
            case 41: {
                this.token = Token.CLOSE;
                break;
            }
            case 94: 
            case 8891: {
                this.token = Token.XOR;
                break;
            }
            case 38: {
                c = this.readChar();
                if (c != 38) {
                    this.unreadChar(c);
                }
            }
            case 42: 
            case 8743: {
                this.token = Token.AND;
                break;
            }
            case 124: {
                c = this.readChar();
                if (c != 124) {
                    this.unreadChar(c);
                }
            }
            case 35: 
            case 43: 
            case 8744: {
                this.token = Token.OR;
                break;
            }
            case 33: 
            case 126: 
            case 172: {
                c = this.readChar();
                if (c != 61) {
                    this.unreadChar(c);
                    this.token = Token.NOT;
                    break;
                }
                this.token = Token.NOTEQUAL;
                break;
            }
            case 44: 
            case 59: {
                this.token = Token.COMMA;
                break;
            }
            case 61: {
                this.token = Token.EQUAL;
                break;
            }
            case 39: {
                this.token = Token.POSTNOT;
                break;
            }
            default: {
                if (this.isIdentChar(c)) {
                    this.token = Token.IDENT;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                    boolean wasChar = true;
                    do {
                        if (this.isIdentChar(c = this.readChar()) || this.isNumberChar(c)) {
                            this.builder.append((char)c);
                            continue;
                        }
                        this.unreadChar(c);
                        wasChar = false;
                    } while (wasChar);
                    break;
                }
                this.token = Token.UNKNOWN;
                this.builder.setLength(0);
                this.builder.append((char)c);
            }
        }
        this.isToken = true;
        return this.token;
    }

    public String getIdent() {
        return this.builder.toString();
    }

    private int readChar() throws IOException {
        if (this.isUnreadChar) {
            this.isUnreadChar = false;
            return this.unreadChar;
        }
        return this.in.read();
    }

    private void unreadChar(int c) {
        this.unreadChar = c;
        this.isUnreadChar = true;
    }

    private boolean isIdentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 92;
    }

    private boolean isNumberChar(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    public String toString() {
        if (this.token == Token.IDENT || this.token == Token.UNKNOWN) {
            return this.getIdent();
        }
        return this.token.name();
    }

    static enum Token {
        UNKNOWN,
        IDENT,
        AND,
        OR,
        NOT,
        XOR,
        OPEN,
        CLOSE,
        ONE,
        ZERO,
        EOF,
        COMMA,
        EQUAL,
        NOTEQUAL,
        POSTNOT;

    }
}

