/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;

public class BoolTableByteArray
implements BoolTable {
    private final byte[] table;

    public BoolTableByteArray(int rows) {
        this(new byte[rows]);
    }

    public BoolTableByteArray(byte[] table) {
        this.table = table;
    }

    public BoolTableByteArray(String values) {
        this(BoolTableByteArray.parseString(values));
    }

    private static byte[] parseString(String values) {
        byte[] table = new byte[values.length()];
        int i = 0;
        while (i < values.length()) {
            switch (values.charAt(i)) {
                case '0': {
                    table[i] = 0;
                    break;
                }
                case '1': {
                    table[i] = 1;
                    break;
                }
                default: {
                    table[i] = 2;
                }
            }
            ++i;
        }
        return table;
    }

    public BoolTableByteArray(BoolTable values) {
        this.table = new byte[values.size()];
        int i = 0;
        while (i < values.size()) {
            this.table[i] = (byte)values.get(i).asInt();
            ++i;
        }
    }

    @Override
    public int size() {
        return this.table.length;
    }

    @Override
    public ThreeStateValue get(int i) {
        return ThreeStateValue.value(this.table[i]);
    }

    public void set(int row, boolean bool) {
        this.set(row, bool ? 1 : 0);
    }

    public void set(int row, int value) {
        this.table[row] = (byte)value;
    }

    public static BoolTableByteArray createDoubledValues(BoolTable values) {
        BoolTableByteArray t = new BoolTableByteArray(values.size() * 2);
        int i = 0;
        while (i < values.size()) {
            int v = values.get(i).asInt();
            t.set(i * 2, v);
            t.set(i * 2 + 1, v);
            ++i;
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.table.length);
        byte[] byArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            switch (b) {
                case 0: {
                    sb.append('0');
                    break;
                }
                case 1: {
                    sb.append('1');
                    break;
                }
                default: {
                    sb.append('X');
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public void modify(TableModifier m) {
        int i = 0;
        while (i < this.table.length) {
            this.table[i] = m.modify(this.table[i]);
            ++i;
        }
    }

    public static interface TableModifier {
        public byte modify(byte var1);
    }
}

