/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.QuineMcCluskey;
import de.neemann.digital.analyse.quinemc.TableRow;
import de.neemann.digital.analyse.quinemc.primeselector.PrimeSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuineMcCluskeyExam
extends QuineMcCluskey {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuineMcCluskeyExam.class);

    public QuineMcCluskeyExam(List<Variable> variables) {
        super(variables);
    }

    @Override
    public void simplifyPrimes(PrimeSelector primeSelector) {
        ArrayList<TableRow> primes = this.getPrimes();
        ArrayList<TableRow> primesAvail = new ArrayList<TableRow>(primes);
        primes.clear();
        TreeSet<Integer> termIndices = new TreeSet<Integer>();
        for (TableRow r : primesAvail) {
            termIndices.addAll(r.getSource());
        }
        Iterator<TableRow> iterator = termIndices.iterator();
        while (iterator.hasNext()) {
            int pr = (Integer)((Object)iterator.next());
            TableRow foundPrime = null;
            for (TableRow tr : primesAvail) {
                if (!tr.getSource().contains(pr)) continue;
                if (foundPrime == null) {
                    foundPrime = tr;
                    continue;
                }
                foundPrime = null;
                break;
            }
            if (foundPrime == null || primes.contains(foundPrime)) continue;
            primes.add(foundPrime);
        }
        primesAvail.removeAll(primes);
        for (TableRow pr : primes) {
            termIndices.removeAll(pr.getSource());
        }
        LOGGER.debug("residual primes " + primesAvail.size());
        if (!termIndices.isEmpty()) {
            Iterator<TableRow> it = primesAvail.iterator();
            while (it.hasNext()) {
                TableRow tr = it.next();
                boolean needed = false;
                Iterator<Comparable<TableRow>> iterator2 = tr.getSource().iterator();
                while (iterator2.hasNext()) {
                    int i = (Integer)iterator2.next();
                    if (!termIndices.contains(i)) continue;
                    needed = true;
                    break;
                }
                if (needed) continue;
                it.remove();
            }
            primeSelector.select(primes, primesAvail, termIndices);
        }
        LOGGER.debug("final primes " + primes.size());
    }
}

