/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.ATF150x;

import de.neemann.digital.builder.tt2.OSExecute;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import de.neemann.gui.LineBreaker;
import de.neemann.gui.Screen;
import de.neemann.gui.ToolTipAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ATFDialog
extends JDialog {
    private final JDialog parent;
    private final JLabel label;
    private final ToolTipAction startATMISPAction;
    private final JButton okButton;
    private File chnFile;
    private String fitterResult;

    ATFDialog(final JDialog parent) {
        super(parent, Lang.get("msg_fitterResult", new Object[0]), true);
        this.setDefaultCloseOperation(2);
        this.parent = parent;
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(this.label);
        JPanel buttons = new JPanel(new FlowLayout(2));
        this.startATMISPAction = new ToolTipAction(Lang.get("btn_startATMISP", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File atmispFile = Settings.getInstance().get(Keys.SETTINGS_ATMISP);
                ArrayList<String> args = new ArrayList<String>();
                if (Screen.isLinux()) {
                    args.add("wine");
                }
                args.add(atmispFile.getPath());
                args.add(ATFDialog.this.chnFile.getName());
                ATFDialog.this.startATMISPAction.setEnabled(false);
                final OSExecute atmisp = new OSExecute(args).setWorkingDir(ATFDialog.this.chnFile.getParentFile()).setTimeOutSec(6000);
                final WindowAdapter windowListener = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        if (atmisp.isAlive()) {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(parent, Lang.get("msg_ATMISPIsStillRunning", new Object[0]));
                                atmisp.terminate();
                            });
                        }
                    }
                };
                ATFDialog.this.addWindowListener(windowListener);
                atmisp.startInThread(new OSExecute.ProcessCallback(){

                    @Override
                    public void processTerminated(String consoleOut) {
                        SwingUtilities.invokeLater(() -> {
                            ATFDialog.this.startATMISPAction.setEnabled(true);
                            ATFDialog.this.removeWindowListener(windowListener);
                        });
                    }

                    @Override
                    public void exception(Exception e) {
                        SwingUtilities.invokeLater(() -> {
                            ATFDialog.this.startATMISPAction.setEnabled(true);
                            ATFDialog.this.removeWindowListener(windowListener);
                            new ErrorMessage(Lang.get("msg_errorStartingATMISP", new Object[0])).addCause(e).show();
                        });
                    }
                });
            }
        }.setToolTip(Lang.get("btn_startATMISP_tt", new Object[0])).setEnabledChain(false);
        buttons.add(this.startATMISPAction.createJButton());
        this.okButton = new ToolTipAction(Lang.get("ok", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ATFDialog.this.dispose();
            }
        }.createJButton();
        buttons.add(this.okButton);
        this.getContentPane().add((Component)buttons, "South");
        SwingUtilities.getRootPane(this.okButton).setDefaultButton(this.okButton);
    }

    void setChnFile(File chnFile) {
        this.chnFile = chnFile;
        this.checkStartATMISP();
    }

    private void checkStartATMISP() {
        if (this.fitterResult != null && this.chnFile != null && this.fitterResult.contains("Design fits successfully")) {
            this.startATMISPAction.setEnabled(true);
        } else {
            this.startATMISPAction.setEnabled(false);
        }
        this.okButton.requestFocusInWindow();
    }

    public void setFitterResult(String fitterResult) {
        this.fitterResult = fitterResult;
        this.label.setText(new LineBreaker().preserveContainedLineBreaks().toHTML().breakLines(fitterResult));
        this.checkStartATMISP();
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }
}

