/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.ATF150x;

import de.neemann.digital.builder.ATF150x.ATFDialog;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.SwingUtilities;

public class CreateCHN
implements ExpressionToFileExporter.PostProcess {
    private final String device;
    private final ATFDialog atfDialog;

    public CreateCHN(String device, ATFDialog atfDialog) {
        this.device = device;
        this.atfDialog = atfDialog;
    }

    @Override
    public File execute(File file) throws IOException {
        File chnFile = SaveAsHelper.checkSuffix(file, "chn");
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter chn = new OutputStreamWriter((OutputStream)new FileOutputStream(chnFile), "ISO-8859-1");){
            chn.write("1 4 1 0 \r\n\r\n" + this.device + "\r\n" + "10\r\n" + "1\r\n");
            chn.write(file.getPath());
            chn.write("\r\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SwingUtilities.invokeLater(() -> this.atfDialog.setChnFile(chnFile));
        return chnFile;
    }

    @Override
    public String getName() {
        return Lang.get("msg_create CHNFile", new Object[0]);
    }
}

