/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.Gal22v10;

import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.builder.BuilderCollector;
import de.neemann.digital.builder.ExpressionExporter;
import de.neemann.digital.builder.Gal16v8.BuilderCollectorGAL;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.builder.jedec.FuseMap;
import de.neemann.digital.builder.jedec.FuseMapFiller;
import de.neemann.digital.builder.jedec.FuseMapFillerException;
import de.neemann.digital.builder.jedec.JedecWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class Gal22v10JEDECExporter
implements ExpressionExporter<Gal22v10JEDECExporter> {
    private static final int[] PRODUCTS_BY_OLMC = new int[]{8, 10, 12, 14, 16, 16, 14, 12, 10, 8};
    private static final int[] OE_FUSE_NUM_BY_OLMC = new int[]{44, 440, 924, 1496, 2156, 2904, 3652, 4312, 4884, 5368};
    private static final int S0 = 5808;
    private static final int S1 = 5809;
    private final FuseMap map = new FuseMap(5892);
    private final FuseMapFiller filler = new FuseMapFiller(this.map, 22);
    private final BuilderCollector builder;
    private final PinMap pinMap = new PinMap().setAvailInputs(2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13).setAvailOutputs(14, 15, 16, 17, 18, 19, 20, 21, 22, 23);

    public Gal22v10JEDECExporter() {
        this.builder = new BuilderCollectorGAL(this.pinMap);
    }

    @Override
    public BuilderCollector getBuilder() {
        return this.builder;
    }

    @Override
    public PinMap getPinMapping() {
        return this.pinMap;
    }

    @Override
    public void writeTo(OutputStream out) throws FuseMapFillerException, IOException, PinMapException {
        int i;
        for (String in : this.builder.getInputs()) {
            i = this.pinMap.getInputFor(in);
            if (i == 13) {
                this.filler.addVariable(21, new Variable(in));
                continue;
            }
            this.filler.addVariable((i - 1) * 2, new Variable(in));
        }
        for (String o : this.builder.getOutputs()) {
            i = 23 - this.pinMap.getOutputFor(o);
            this.filler.addVariableReverse(i * 2 + 1, new Variable(o));
        }
        for (String o : this.builder.getOutputs()) {
            int olmc = 23 - this.pinMap.getOutputFor(o);
            int offs = OE_FUSE_NUM_BY_OLMC[olmc];
            int j = 0;
            while (j < 44) {
                this.map.setFuse(offs + j);
                ++j;
            }
            this.map.setFuse(5808 + olmc * 2);
            if (this.builder.getCombinatorial().containsKey(o)) {
                this.map.setFuse(5809 + olmc * 2);
                this.filler.fillExpression(offs + 44, this.builder.getCombinatorial().get(o), PRODUCTS_BY_OLMC[olmc]);
                continue;
            }
            if (this.builder.getRegistered().containsKey(o)) {
                this.filler.fillExpression(offs + 44, this.builder.getRegistered().get(o), PRODUCTS_BY_OLMC[olmc]);
                continue;
            }
            throw new FuseMapFillerException("variable " + o + " not found!");
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (JedecWriter w = new JedecWriter(out);){
            w.println("Digital GAL22v10 assembler*").write(this.map);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

