/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.circuit;

import de.neemann.digital.builder.circuit.Box;
import de.neemann.digital.builder.circuit.Fragment;
import de.neemann.digital.builder.circuit.FragmentVisitor;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import java.util.Arrays;
import java.util.List;

public class FragmentSameInValue
implements Fragment {
    private final Fragment fragment;
    private Vector pos;

    public FragmentSameInValue(Fragment fragment) {
        this.fragment = fragment;
    }

    @Override
    public Box doLayout() {
        this.fragment.setPos(new Vector(40, 0));
        Box b = this.fragment.doLayout();
        return new Box(40 + b.getWidth(), b.getHeight());
    }

    @Override
    public void setPos(Vector pos) {
        this.pos = pos;
    }

    @Override
    public void addToCircuit(Vector pos, Circuit circuit) {
        List<Vector> in = Vector.add(this.fragment.getInputs(), pos);
        Vector last = null;
        for (Vector v : in) {
            Vector p = v.add(-20, 0);
            circuit.add(new Wire(v, p));
            if (last != null) {
                circuit.add(new Wire(last, p));
            }
            last = p;
        }
        this.fragment.addToCircuit(pos, circuit);
    }

    @Override
    public List<Vector> getInputs() {
        int y = this.fragment.getInputs().get((int)0).y;
        return Arrays.asList(new Vector(20, y));
    }

    @Override
    public List<Vector> getOutputs() {
        return Vector.add(this.fragment.getOutputs(), this.pos);
    }

    @Override
    public <V extends FragmentVisitor> V traverse(V v) {
        v.visit(this);
        this.fragment.traverse(v);
        return v;
    }
}

