/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.tt2;

import java.io.OutputStream;
import java.util.Arrays;

public class RotationByteArrayOutputStream
extends OutputStream {
    private final byte[] buffer;
    private final int size;
    private int inBuffer;
    private int pos;
    private int skipped;

    public RotationByteArrayOutputStream(int size) {
        this.buffer = new byte[size];
        this.size = size;
    }

    @Override
    public void write(int i) {
        this.buffer[this.pos] = (byte)i;
        ++this.pos;
        if (this.pos == this.size) {
            this.pos = 0;
        }
        if (this.inBuffer < this.size) {
            ++this.inBuffer;
        } else {
            ++this.skipped;
        }
    }

    public byte[] toByteArray() {
        if (this.inBuffer < this.size) {
            return Arrays.copyOf(this.buffer, this.inBuffer);
        }
        byte[] ret = new byte[this.size];
        System.arraycopy(this.buffer, this.pos, ret, 0, this.size - this.pos);
        System.arraycopy(this.buffer, 0, ret, this.size - this.pos, this.pos);
        return ret;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public String toString() {
        if (this.skipped > 0) {
            return "skipped bytes: " + this.skipped + "\n" + new String(this.toByteArray());
        }
        return new String(this.toByteArray());
    }
}

