/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ValueFormatter;

public final class Signal
implements Comparable<Signal> {
    private final String name;
    private final ObservableValue value;
    private final Setter setter;
    private ValueFormatter format = IntFormat.DEFAULT_FORMATTER;
    private String pinNumber;
    private ObservableValue bidirectionalReader;
    private boolean showInGraph;
    private boolean testOutput;

    public Signal(String name, ObservableValue value) {
        this(name, value, null);
    }

    public Signal(String name, ObservableValue value, Setter setter) {
        this.setter = setter;
        this.name = name == null ? null : name.trim().replace(' ', '_');
        this.value = value;
        this.showInGraph = true;
    }

    public Signal setShowInGraph(boolean showInGraph) {
        this.showInGraph = showInGraph;
        return this;
    }

    public boolean isShowInGraph() {
        return this.showInGraph;
    }

    public Signal setTestOutput() {
        this.testOutput = true;
        return this;
    }

    public boolean isTestOutput() {
        return this.testOutput;
    }

    public String getName() {
        return this.name;
    }

    public Signal setPinNumber(String pinNumber) {
        this.pinNumber = pinNumber;
        return this;
    }

    public Signal setFormat(ValueFormatter format) {
        if (format != null) {
            this.format = format;
        }
        return this;
    }

    public String getPinNumber() {
        return this.pinNumber;
    }

    public ObservableValue getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Signal o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signal signal = (Signal)o;
        return this.name.equals(signal.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public String getValueString() {
        return this.format.formatToEdit(this.value.getCopy());
    }

    public boolean isValid() {
        return this.name != null && this.name.length() > 0 && this.value != null;
    }

    public boolean missingPinNumber() {
        return this.pinNumber == null || this.pinNumber.trim().length() == 0;
    }

    public Setter getSetter() {
        return this.setter;
    }

    public Signal setBidirectionalReader(ObservableValue bidirectionalReader) {
        this.bidirectionalReader = bidirectionalReader;
        return this;
    }

    public ObservableValue getBidirectionalReader() {
        return this.bidirectionalReader;
    }

    public ValueFormatter getFormat() {
        return this.format;
    }

    public static interface Setter {
        public void set(long var1, long var3);
    }
}

