/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class Div
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Div.class, PinInfo.input("a"), PinInfo.input("b")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.BITS).addAttribute(Keys.SIGNED).addAttribute(Keys.REMAINDER_POSITIVE);
    private final ObservableValue quotient;
    private final ObservableValue remainder;
    private final int bits;
    private final boolean signed;
    private final boolean remainderPositive;
    private ObservableValue a;
    private ObservableValue b;
    private long q;
    private long r;

    public Div(ElementAttributes attributes) {
        this.signed = attributes.get(Keys.SIGNED);
        this.bits = attributes.get(Keys.BITS);
        this.quotient = new ObservableValue("q", this.bits).setPinDescription(DESCRIPTION);
        this.remainder = new ObservableValue("r", this.bits).setPinDescription(DESCRIPTION);
        this.remainderPositive = attributes.get(Keys.REMAINDER_POSITIVE);
    }

    @Override
    public void readInputs() throws NodeException {
        if (this.signed) {
            long av = this.a.getValueSigned();
            long bv = this.b.getValueSigned();
            if (bv == 0L) {
                bv = 1L;
            }
            this.q = av / bv;
            this.r = av % bv;
            if (this.remainderPositive && this.r < 0L) {
                if (bv >= 0L) {
                    this.r += bv;
                    --this.q;
                } else {
                    this.r -= bv;
                    ++this.q;
                }
            }
        } else {
            long av = this.a.getValue();
            long bv = this.b.getValue();
            if (bv == 0L) {
                bv = 1L;
            }
            this.q = Long.divideUnsigned(av, bv);
            this.r = Long.remainderUnsigned(av, bv);
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.quotient.setValue(this.q);
        this.remainder.setValue(this.r);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.a = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this, 0);
        this.b = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.bits, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.quotient, this.remainder);
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

