/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementFactory;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ElementTypeDescription {
    private static final String PINSEPARATOR = "_pin_";
    private final String name;
    private final String langKey;
    private ClassLoader classLoader;
    private String shortName;
    private ElementFactory elementFactory;
    private final PinDescriptions inputPins;
    private final ArrayList<Key> attributeList;
    private boolean supportsHDL;

    public ElementTypeDescription(Class<? extends Element> clazz, PinDescription ... inputPins) {
        this(clazz.getSimpleName(), clazz, inputPins);
    }

    public ElementTypeDescription(String name, Class<? extends Element> clazz, PinDescription ... inputPins) {
        this(name, (ElementAttributes attributes) -> {
            try {
                Constructor constructor = clazz.getConstructor(ElementAttributes.class);
                return (Element)constructor.newInstance(attributes);
            }
            catch (Exception e) {
                throw new RuntimeException(Lang.get("err_couldNotCreateElement_N", name), e);
            }
        }, inputPins);
        this.classLoader = clazz.getClassLoader();
    }

    public ElementTypeDescription(String name, ElementFactory elementFactory, PinDescription ... inputPins) {
        this.name = name;
        this.langKey = "elem_" + name;
        this.elementFactory = elementFactory;
        this.inputPins = new PinDescriptions(inputPins).setLangKey(this.getPinLangKey());
        PinDescription[] pinDescriptionArray = inputPins;
        int n = inputPins.length;
        int n2 = 0;
        while (n2 < n) {
            PinDescription p = pinDescriptionArray[n2];
            if (p.getDirection() != PinDescription.Direction.input) {
                throw new RuntimeException("pin direction error");
            }
            ++n2;
        }
        this.attributeList = new ArrayList();
    }

    public void setElementFactory(ElementFactory elementFactory) {
        this.elementFactory = elementFactory;
    }

    public String getShortName() {
        if (this.shortName == null) {
            String s = Lang.getNull(String.valueOf(this.langKey) + "_short", new Object[0]);
            if (s != null) {
                return s;
            }
            return this.getTranslatedName();
        }
        return this.shortName;
    }

    public String getPinLangKey() {
        return String.valueOf(this.langKey) + PINSEPARATOR;
    }

    public String getTranslatedName() {
        String n = Lang.getNull(this.langKey, new Object[0]);
        if (n != null) {
            return n;
        }
        return this.name;
    }

    public ElementTypeDescription setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getDescription(ElementAttributes elementAttributes) {
        String d = Lang.getNull(String.valueOf(this.langKey) + "_tt", new Object[0]);
        if (d == null) {
            d = this.getTranslatedName();
        }
        if (this.supportsHDL) {
            d = String.valueOf(d) + " " + Lang.get("msg_supportsHDL", new Object[0]);
        }
        return d;
    }

    public <VALUE> ElementTypeDescription addAttribute(Key<VALUE> key) {
        this.attributeList.add(key);
        if (key == Keys.INT_FORMAT) {
            this.attributeList.add(Keys.FIXED_POINT);
        }
        return this;
    }

    public ElementTypeDescription supportsHDL() {
        this.supportsHDL = true;
        return this;
    }

    public boolean isSupportsHDL() {
        return this.supportsHDL;
    }

    public ArrayList<Key> getAttributeList() {
        return this.attributeList;
    }

    public String getName() {
        return this.name;
    }

    public PinDescriptions getInputDescription(ElementAttributes elementAttributes) throws NodeException {
        return this.inputPins;
    }

    public PinDescriptions getOutputDescriptions(ElementAttributes elementAttributes) throws PinException {
        return new PinDescriptions(this.elementFactory.create(elementAttributes).getOutputs());
    }

    public Element createElement(ElementAttributes elementAttributes) {
        return this.elementFactory.create(elementAttributes);
    }

    public boolean hasAttribute(Key key) {
        return this.attributeList.contains(key);
    }

    public PinDescription getInput(int i) {
        if (i >= this.inputPins.size()) {
            return null;
        }
        return (PinDescription)this.inputPins.get(i);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

