/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.arithmetic.BarrelShifterMode;
import de.neemann.digital.core.arithmetic.LeftRightFormat;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.io.CommonConnectionType;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.io.ProbeMode;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.rom.ROMManagerFile;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.shapes.CustomCircuitShapeType;
import de.neemann.digital.draw.shapes.custom.CustomShapeDescription;
import de.neemann.digital.gui.components.data.ScopeTrigger;
import de.neemann.digital.testing.TestCaseDescription;
import de.neemann.gui.Screen;
import de.neemann.gui.language.Language;
import java.awt.Color;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;

public final class Keys {
    public static final Key.KeyBits BITS = new Key.KeyBits("Bits", 1);
    public static final Key.KeyBits INPUT_BITS = new Key.KeyBits("inputBits", 8);
    public static final Key.KeyBits OUTPUT_BITS = new Key.KeyBits("outputBits", 16);
    public static final Key.KeyInteger INPUT_COUNT = new Key.KeyInteger("Inputs", 2).setComboBoxValues(2, 3, 4, 5).setMin(2);
    public static final Key.KeyInteger LUT_INPUT_COUNT = new Key.KeyInteger("Inputs", 2).setComboBoxValues(2, 3, 4, 5, 6).setMax(20).setMin(2);
    public static final Key.KeyInteger MAX_VALUE = new Key.KeyInteger("maxValue", 0).setMin(0);
    public static final Key.KeyInteger DELAY_TIME = new Key.KeyInteger("delayTime", 1).setComboBoxValues(1, 2, 3, 4, 5).setMin(1).setMax(20);
    public static final Key.KeyInteger MONOFLOP_DELAY = new Key.KeyInteger("timerDelay", 1).setMin(1);
    public static final Key<String> LABEL = new Key<String>("Label", "");
    public static final Key<Integer> FONT_SIZE = new Key.KeyInteger("textFontSize", Style.NORMAL.getFontSize()).setComboBoxValues(14, 17, 20, 24, 36, 48, 60).setMin(10).setMax(70);
    public static final Key<Orientation> TEXT_ORIENTATION = new Key.KeyEnum("textOrientation", (Enum)Orientation.LEFTTOP, (Enum[])Orientation.values()).setSecondary();
    public static final Key<Integer> LED_SIZE = new Key.KeyInteger("Size", 1).setComboBoxValues(0, 1, 2, 3, 4, 5).setMin(0).allowGroupEdit().setSecondary();
    public static final Key<Integer> SEVEN_SEG_SIZE = new Key.KeyInteger("segSize", 2).setComboBoxValues(0, 1, 2, 3, 4, 5).setMin(0).allowGroupEdit().useTranslationOf(LED_SIZE);
    public static final Key<Long> VALUE = new Key<Long>("Value", 1L).setAdaptiveIntFormat().allowGroupEdit();
    public static final Key<Long> DEFAULT = new Key<Long>("Default", 0L).allowGroupEdit().setSecondary();
    public static final Key<InValue> INPUT_DEFAULT = new Key<InValue>("InDefault", new InValue(0L)).setAdaptiveIntFormat().allowGroupEdit().setSecondary();
    public static final Key<Boolean> DIP_DEFAULT = new Key<Boolean>("dipDefault", false).allowGroupEdit().setSecondary();
    public static final Key<Color> COLOR = new Key<Color>("Color", Color.RED).allowGroupEdit();
    public static final Key<String> INPUT_SPLIT = new Key<String>("Input Splitting", "4,4");
    public static final Key<String> OUTPUT_SPLIT = new Key<String>("Output Splitting", "8");
    public static final Key<Integer> SPLITTER_SPREADING = new Key.KeyInteger("splitterSpreading", 1).setComboBoxValues(1, 2, 3, 4).setMin(1).setMax(20).setSecondary();
    public static final Key<Boolean> IN_OUT_SMALL = new Key<Boolean>("small", false).allowGroupEdit().setSecondary();
    public static final Key<Boolean> RUN_AT_REAL_TIME = new Key<Boolean>("runRealTime", false);
    public static final Key<Boolean> INVERT_OUTPUT = new Key<Boolean>("invertOutput", true);
    public static final Key<Boolean> INVERT_DRIVER_OUTPUT = new Key<Boolean>("invertDriverOutput", false).useTranslationOf(INVERT_OUTPUT).allowGroupEdit();
    public static final Key<Integer> FREQUENCY = new Key.KeyInteger("Frequency", 1).setComboBoxValues(1, 2, 5, 10, 20, 50, 100, 200, 500, 5000, 50000, Integer.MAX_VALUE).setMin(1).setDependsOn(RUN_AT_REAL_TIME);
    public static final Key<Integer> SELECTOR_BITS = new Key.KeyBits("Selector Bits", 1).setMax(8);
    public static final Key<Integer> ADDR_BITS = new Key.KeyBits("AddrBits", 2).setMax(24);
    public static final Key<Boolean> BLOWN = new Key<Boolean>("Blown", false).allowGroupEdit();
    public static final Key<Boolean> CLOSED = new Key<Boolean>("Closed", false).allowGroupEdit();
    public static final Key<Boolean> SIGNED = new Key<Boolean>("Signed", false).allowGroupEdit();
    public static final Key<Boolean> REMAINDER_POSITIVE = new Key<Boolean>("remainderPositive", true).setDependsOn(SIGNED);
    public static final Key<DataField> DATA = new Key<DataField>("Data", DataField::new);
    public static final Key<Boolean> FLIP_SEL_POSITON = new Key<Boolean>("flipSelPos", false).allowGroupEdit();
    public static final Key<Rotation> ROTATE = new Key<Rotation>("rotation", new Rotation(0)).allowGroupEdit().setSecondary();
    public static final Key.KeyInteger WIDTH = new Key.KeyInteger("Width", 3).setMin(2);
    public static final Key<CustomCircuitShapeType> SHAPE_TYPE = new Key.KeyEnum("shapeType", (Enum)CustomCircuitShapeType.DEFAULT, (Enum[])CustomCircuitShapeType.values()).setSecondary();
    public static final Key.KeyInteger LAYOUT_SHAPE_DELTA = new Key.KeyInteger("layoutShapeDelta", 0).setMin(0);
    public static final Key<Integer> HEIGHT = new Key.KeyInteger("Height", 3).setMin(2).setSecondary().setDependsOn(SHAPE_TYPE, cst -> cst.equals((Object)CustomCircuitShapeType.LAYOUT));
    public static final Key.KeyInteger TERM_WIDTH = new Key.KeyInteger("termWidth", 50).setMin(10);
    public static final Key.KeyInteger TERM_HEIGHT = new Key.KeyInteger("termHeight", 25).setMin(5);
    public static final Key.KeyInteger CYCLES = new Key.KeyInteger("Cycles", 100000).setComboBoxValues(1000, 10000, 100000, 1000000);
    public static final Key<Boolean> ENABLED = new Key<Boolean>("enabled", true).allowGroupEdit();
    public static final Key<Boolean> VALUE_IS_PROBE = new Key<Boolean>("valueIsProbe", false).allowGroupEdit().setSecondary();
    public static final Key<Boolean> IS_PROGRAM_MEMORY = new Key<Boolean>("isProgramMemory", false).setSecondary();
    public static final Key<Boolean> IS_PROGRAM_COUNTER = new Key<Boolean>("isProgramCounter", false).setSecondary();
    public static final Key<Boolean> AUTO_RELOAD_ROM = new Key<Boolean>("autoReload", false).setSecondary();
    public static final Key<File> LAST_DATA_FILE = new Key.KeyFile("lastDataFile", new File("")).setDependsOn(AUTO_RELOAD_ROM).setSecondary();
    public static final Key<Boolean> SHOW_DATA_TABLE = new Key<Boolean>("showDataTable", false).setSecondary();
    public static final Key<Boolean> SHOW_DATA_GRAPH = new Key<Boolean>("showDataGraph", false).setSecondary();
    public static final Key<Boolean> SHOW_DATA_GRAPH_MICRO = new Key<Boolean>("showDataGraphMicro", false).setSecondary();
    public static final Key<Boolean> ADD_VALUE_TO_GRAPH = new Key<Boolean>("addValueToGraph", true).allowGroupEdit().setSecondary();
    public static final Key<Boolean> MICRO_STEP = new Key<Boolean>("microStep", false);
    public static final Key.KeyInteger MAX_STEP_COUNT = new Key.KeyInteger("maxStepCount", 25).setMin(5);
    public static final Key<Integer> SETTINGS_MAX_STEP_COUNT = new Key.KeyInteger("settingsMaxStepCount", 1000).setComboBoxValues(500, 1000, 5000, 10000).setMin(500).setSecondary().useTranslationOf(MAX_STEP_COUNT);
    public static final Key<Boolean> IS_HIGH_Z = new Key<Boolean>("isHighZ", false).allowGroupEdit().setSecondary();
    public static final Key<Boolean> AVOID_ACTIVE_LOW = new Key<Boolean>("avoidActiveLow", false).setDependsOn(IS_HIGH_Z).allowGroupEdit().setSecondary();
    public static final Key.LongString DESCRIPTION = new Key.LongString("Description");
    public static final Key<String> NETNAME = new Key<String>("NetName", "");
    public static final Key<Boolean> SETTINGS_IEEE_SHAPES = new Key<Boolean>("IEEEShapes", !Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage())).setRequiresRestart();
    public static final Key<Language> SETTINGS_LANGUAGE = new Key<Language>("Language", new Language()).setRequiresRestart();
    public static final Key<Boolean> SETTINGS_DEFAULT_TREESELECT = new Key<Boolean>("defTreeSelect", false);
    public static final Key.KeyEnum<FormatToExpression> SETTINGS_EXPRESSION_FORMAT = new Key.KeyEnum("ExpressionFormat", (Enum)FormatToExpression.UNICODE, (Enum[])FormatToExpression.values(), true);
    public static final Key<Boolean> SETTINGS_GRID = new Key<Boolean>("grid", true).setRequiresRepaint();
    public static final Key<Boolean> SETTINGS_SHOW_WIRE_BITS = new Key<Boolean>("showWireBits", false);
    public static final Key<Boolean> SETTINGS_MAC_MOUSE = new Key<Boolean>("macMouse", false).setRequiresRestart().setSecondary();
    public static final Key<Boolean> SETTINGS_SHOW_TUNNEL_RENAME_DIALOG = new Key<Boolean>("tunnelRenameDialog", true);
    public static final Key<Boolean> SETTINGS_RENAME_LABELS = new Key<Boolean>("renameLabels", true);
    public static final Key<Boolean> SETTINGS_OPEN_REMOTE_PORT = new Key<Boolean>("openRemotePort", false).setSecondary().setRequiresRestart();
    public static final Key<Integer> SETTINGS_REMOTE_PORT = new Key.KeyInteger("remotePort", 41114).setMin(0).setMax(65535).setComboBoxValues(41114).setSecondary().setRequiresRestart().setDependsOn(SETTINGS_OPEN_REMOTE_PORT);
    public static final Key<Integer> OSCILLATION_DETECTION_COUNTER = new Key.KeyInteger("oscillationDetectionCounter", 1000).setComboBoxValues(1000, 5000, 10000).setMin(1000).setMax(100000);
    public static final Key<IntFormat> INT_FORMAT = new Key.KeyEnum("intFormat", (Enum)IntFormat.def, (Enum[])IntFormat.values()).setSecondary();
    public static final Key<ProbeMode> PROBE_MODE = new Key.KeyEnum("probeMode", (Enum)ProbeMode.VALUE, (Enum[])ProbeMode.values());
    public static final Key<Integer> FIXED_POINT = new Key.KeyInteger("fixedPoint", 4).setMin(1).setMax(64).setDependsOn(INT_FORMAT, intFormat -> intFormat.equals((Object)IntFormat.fixed) || intFormat.equals((Object)IntFormat.fixedSigned)).allowGroupEdit().setSecondary();
    public static final Key.KeyInteger GRAPHIC_WIDTH = new Key.KeyInteger("graphicWidth", 160).setMin(4);
    public static final Key.KeyInteger GRAPHIC_HEIGHT = new Key.KeyInteger("graphicHeight", 100).setMin(4);
    public static final Key<Boolean> RELAY_NORMALLY_CLOSED = new Key<Boolean>("relayNormallyClosed", false).allowGroupEdit();
    public static final Key<Integer> POLES = new Key.KeyInteger("poles", 1).setComboBoxValues(1, 2, 3, 4).setMin(1).allowGroupEdit();
    public static final Key<BarrelShifterMode> BARREL_SHIFTER_MODE = new Key.KeyEnum("barrelShifterMode", (Enum)BarrelShifterMode.logical, (Enum[])BarrelShifterMode.values());
    public static final Key<LeftRightFormat> DIRECTION = new Key.KeyEnum("direction", (Enum)LeftRightFormat.left, (Enum[])LeftRightFormat.values());
    public static final Key<Boolean> BARREL_SIGNED = new Key<Boolean>("barrelSigned", false);
    public static final Key<Boolean> COMMON_CONNECTION = new Key<Boolean>("commonCathode", false).allowGroupEdit();
    public static final Key<CommonConnectionType> COMMON_CONNECTION_TYPE = new Key.KeyEnum("commonConnectionType", (Enum)CommonConnectionType.cathode, (Enum[])CommonConnectionType.values()).setDependsOn(COMMON_CONNECTION).allowGroupEdit();
    public static final Key<Boolean> LED_PERSISTENCE = new Key<Boolean>("ledPersistence", false).allowGroupEdit().setDependsOn(COMMON_CONNECTION);
    public static final Key<Integer> LED_PERSIST_TIME = new Key.KeyInteger("persistTime", 0).setMin(0).allowGroupEdit();
    public static final Key<File> SETTINGS_ATF1502_FITTER = new Key.KeyFile("atf1502Fitter", new File("c:/Wincupl/WinCupl/Fitters")).setDirectoryOnly(true).setSecondary();
    public static final Key<File> SETTINGS_ATMISP = new Key.KeyFile("ATMISP", Keys.getATMISPPath()).setSecondary();
    public static final Key.KeyBits ROW_DATA_BITS = new Key.KeyBits("rowDataBits", 8);
    public static final Key.KeyBits COL_ADDR_BITS = new Key.KeyBits("colAddrBits", 3);
    public static final Key<Boolean> LOCKED_MODE = new Key<Boolean>("lockedMode", false);
    public static final Key<String> PINNUMBER = new Key<String>("pinNumber", "").setSecondary();
    public static final Key<Integer> PINCOUNT = new Key.KeyInteger("pinCount", 0).setMin(0).setSecondary().setDependsOn(SHAPE_TYPE, st -> st.equals((Object)CustomCircuitShapeType.DIL));
    public static final Key<InverterConfig> INVERTER_CONFIG = new Key<InverterConfig>("inverterConfig", new InverterConfig.Builder().build());
    public static final Key<Color> BACKGROUND_COLOR = new Key<Color>("backgroundColor", new Color(255, 255, 180, 200));
    public static final Key<Integer> SETTINGS_FONT_SCALING = new Key.KeyInteger("fontSize", Screen.getDefaultFontScaling()).setComboBoxValues(100, 120, 150, 180, 200, 250, 300).setMin(50).setMax(400).setRequiresRestart().setSecondary();
    public static final Key<Boolean> SETTINGS_USE_EQUALS_KEY;
    public static final Key<Boolean> WITH_ENABLE;
    public static final Key<Boolean> FET_UNIDIRECTIONAL;
    public static final Key<Boolean> ACTIVE_LOW;
    public static final Key<Boolean> MAP_TO_KEY;
    public static final Key<File> SETTINGS_LIBRARY_PATH;
    public static final Key<File> SETTINGS_JAR_PATH;
    public static final Key<ROMManagerFile> ROMMANAGER;
    public static final Key.KeyEnum<Application.Type> APPLICATION_TYPE;
    public static final Key<String> EXTERNAL_INPUTS;
    public static final Key<String> EXTERNAL_OUTPUTS;
    public static final Key<String> EXTERNAL_PARAMETERS;
    public static final Key.LongString EXTERNAL_CODE;
    public static final Key.KeyFile EXTERNAL_CODE_FILE;
    public static final Key<File> SETTINGS_GHDL_PATH;
    public static final Key<String> GHDL_OPTIONS;
    public static final Key<String> IVERILOG_OPTIONS;
    public static final Key<File> SETTINGS_IVERILOG_PATH;
    public static final Key<CustomShapeDescription> CUSTOM_SHAPE;
    public static final Key<Boolean> PRELOAD_PROGRAM;
    public static final Key<Boolean> BIG_ENDIAN;
    public static final Key<File> PROGRAM_TO_PRELOAD;
    public static final Key<Boolean> BIG_ENDIAN_SETTING;
    public static final Key<Boolean> WIDE_SHAPE;
    public static final Key.KeyInteger RECT_WIDTH;
    public static final Key.KeyInteger RECT_HEIGHT;
    public static final Key<Boolean> RECT_INSIDE;
    public static final Key<Boolean> RECT_BOTTOM;
    public static final Key<Boolean> RECT_RIGHT;
    public static final Key.KeyInteger MIDI_CHANNEL;
    public static final Key<String> MIDI_INSTRUMENT;
    public static final Key<Boolean> MIDI_PROG_CHANGE;
    public static final Key<File> SETTINGS_TOOLCHAIN_CONFIG;
    public static final Key<String> GENERIC;
    public static final Key<String> GENERICLARGE;
    public static final Key<Boolean> IS_GENERIC;
    public static final Key<Boolean> SETTINGS_SHOW_TUTORIAL;
    public static final Key<Boolean> SETTINGS_WIRETOOLTIP;
    public static final Key<Boolean> SWITCH_ACTS_AS_INPUT;
    public static final Key<Boolean> SNAP_TO_GRID;
    public static final Key<Boolean> MIRROR;
    public static final Key<TestCaseDescription> TESTDATA;
    public static final Key.KeyEnum<ScopeTrigger.Trigger> TRIGGER;
    public static final Key.KeyInteger PORT;
    public static final Key<Boolean> TELNET_ESCAPE;
    public static final Key<Boolean> SKIP_HDL;

    static {
        String language = Locale.getDefault().getLanguage();
        SETTINGS_USE_EQUALS_KEY = new Key<Boolean>("equalsInsteadOfPlus", language.equals("en") || language.equals("fr"));
        WITH_ENABLE = new Key<Boolean>("withEnable", true);
        FET_UNIDIRECTIONAL = new Key<Boolean>("unidirectional", false);
        ACTIVE_LOW = new Key<Boolean>("activeLow", false).allowGroupEdit();
        MAP_TO_KEY = new Key<Boolean>("mapToKey", false).allowGroupEdit();
        SETTINGS_LIBRARY_PATH = new Key.KeyFile("libraryPath", ElementLibrary.getLibPath()).setDirectoryOnly(true).setSecondary();
        SETTINGS_JAR_PATH = new Key.KeyFile("jarPath", new File("")).setSecondary().setRequiresRestart();
        ROMMANAGER = new Key<ROMManagerFile>("romContent", ROMManagerFile::new).setSecondary();
        APPLICATION_TYPE = new Key.KeyEnum("applicationType", (Enum)Application.Type.Generic, (Enum[])Application.Type.values());
        EXTERNAL_INPUTS = new Key<String>("externalInputs", "in");
        EXTERNAL_OUTPUTS = new Key<String>("externalOutputs", "out");
        EXTERNAL_PARAMETERS = new Key<String>("externalParameters", "par");
        EXTERNAL_CODE = new Key.LongString("Code").setRows(30).setColumns(80).setLineNumbers(true);
        EXTERNAL_CODE_FILE = new Key.KeyFile("CodeFile", new File(""));
        SETTINGS_GHDL_PATH = new Key.KeyFile("ghdlPath", new File("ghdl")).setSecondary();
        GHDL_OPTIONS = new Key.LongString("ghdlOptions", "--std=08 --ieee=synopsys").setRows(3).setColumns(30).setPanelId("Options");
        IVERILOG_OPTIONS = new Key.LongString("iverilogOptions", "").setRows(3).setColumns(30).setPanelId("Options");
        SETTINGS_IVERILOG_PATH = new Key.KeyFile("iverilogPath", new File("iverilog")).setSecondary();
        CUSTOM_SHAPE = new Key<CustomShapeDescription>("customShape", new CustomShapeDescription.Builder().build()).setSecondary().setDependsOn(SHAPE_TYPE, st -> st.equals((Object)CustomCircuitShapeType.CUSTOM));
        PRELOAD_PROGRAM = new Key<Boolean>("preloadProgram", false).setSecondary();
        BIG_ENDIAN = new Key<Boolean>("bigEndian", false).setSecondary().setDependsOn(AUTO_RELOAD_ROM);
        PROGRAM_TO_PRELOAD = new Key.KeyFile("preloadProgramFile", new File("")).setSecondary().setDependsOn(PRELOAD_PROGRAM);
        BIG_ENDIAN_SETTING = new Key<Boolean>("bigEndianSetting", false).setSecondary().useTranslationOf(BIG_ENDIAN).setDependsOn(PRELOAD_PROGRAM);
        WIDE_SHAPE = new Key<Boolean>("wideShape", false).setSecondary().allowGroupEdit();
        RECT_WIDTH = new Key.KeyInteger("RectWidth", 3).setMin(2);
        RECT_HEIGHT = new Key.KeyInteger("RectHeight", 3).setMin(2);
        RECT_INSIDE = new Key<Boolean>("RectInside", false).setSecondary();
        RECT_BOTTOM = new Key<Boolean>("RectBottom", false).setSecondary();
        RECT_RIGHT = new Key<Boolean>("RectRight", false).setSecondary();
        MIDI_CHANNEL = new Key.KeyInteger("midiChannel", 1).setMin(1).setMax(16);
        MIDI_INSTRUMENT = new Key<String>("midiInstrument", "");
        MIDI_PROG_CHANGE = new Key<Boolean>("midiProgChange", false);
        SETTINGS_TOOLCHAIN_CONFIG = new Key.KeyFile("toolChainConfig", new File("")).setSecondary().setRequiresRestart();
        GENERIC = new Key.LongString("generic").setLineNumbers(true).allowGroupEdit();
        GENERICLARGE = new Key.LongString("generic").setLineNumbers(true).setRows(20).allowGroupEdit();
        IS_GENERIC = new Key<Boolean>("isGeneric", false).setSecondary();
        SETTINGS_SHOW_TUTORIAL = new Key<Boolean>("showTutorial", true).setSecondary();
        SETTINGS_WIRETOOLTIP = new Key<Boolean>("wireToolTips", false);
        SWITCH_ACTS_AS_INPUT = new Key<Boolean>("switchActsAsInput", false).setSecondary();
        SNAP_TO_GRID = new Key<Boolean>("snapToGrid", true).setSecondary();
        MIRROR = new Key<Boolean>("mirror", false).allowGroupEdit().setSecondary();
        TESTDATA = new Key<TestCaseDescription>("Testdata", TestCaseDescription::new);
        TRIGGER = new Key.KeyEnum("trigger", (Enum)ScopeTrigger.Trigger.both, (Enum[])ScopeTrigger.Trigger.values());
        PORT = new Key.KeyInteger("port", 23).setMin(1).setMax(65535);
        TELNET_ESCAPE = new Key<Boolean>("telnetEscape", true).allowGroupEdit();
        SKIP_HDL = new Key<Boolean>("skipHDL", false).setSecondary();
    }

    public static Key getKeyByName(String name) {
        return (Key)InstanceHolder.INSTANCE.get(name);
    }

    public static Iterable<Key> getKeys() {
        return InstanceHolder.INSTANCE.values();
    }

    private Keys() {
    }

    private static File getATMISPPath() {
        File f = new File("c:/Tools/ATMISP7/ATMISP.exe");
        if (f.exists()) {
            return f;
        }
        return new File("c:/ATMISP7/ATMISP.exe");
    }

    private static final class InstanceHolder {
        private static final HashMap<String, Key> INSTANCE = InstanceHolder.createMap();

        private InstanceHolder() {
        }

        private static HashMap<String, Key> createMap() {
            HashMap<String, Key> map = new HashMap<String, Key>();
            Field[] fieldArray = Keys.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field k = fieldArray[n2];
                if (Modifier.isStatic(k.getModifiers()) && Key.class.isAssignableFrom(k.getType())) {
                    try {
                        Key key = (Key)k.get(null);
                        String keyName = key.getKey();
                        if (map.containsKey(keyName) && !map.get(keyName).getDefault().equals(key.getDefault())) {
                            throw new RuntimeException("duplicate key with different default: " + keyName);
                        }
                        map.put(keyName, key);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("error accessing the Keys");
                    }
                }
                ++n2;
            }
            return map;
        }
    }
}

