/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.ParamDefinition;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.VerilogTokenizer;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.Statement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;

public abstract class ApplicationVerilogStdIO
implements Application {
    private VerilogTokenizer.Token currToken;
    private static final Statement TEMPLATE = Parser.createFromJarStatic("verilog/VerilogStdIOTemplate.vtpl");

    public File createVerilogFile(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File dir = Files.createTempDirectory("digital_verilog_", new FileAttribute[0]).toFile();
        File file = new File(dir, String.valueOf(label) + ".v");
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (FileWriter w = new FileWriter(file);){
                w.write(this.createVerilog(label, code, inputs, outputs, root));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (HGSEvalException e) {
            throw new IOException("error evaluating the template", e);
        }
        return file;
    }

    public String createVerilog(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws HGSEvalException {
        Context context = new Context(root).declareVar("moduleName", label).declareVar("code", code).declareVar("inputs", inputs).declareVar("outputs", outputs);
        TEMPLATE.execute(context);
        return context.toString();
    }

    private void match(VerilogTokenizer.Token tkExpect, String tkText, VerilogTokenizer st) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        if (this.currToken != tkExpect) {
            throw new ParseException("unexpected '" + tkText + "'");
        }
        this.currToken = st.nextToken();
    }

    private boolean match0(VerilogTokenizer.Token tkExpect, String tkText, VerilogTokenizer st) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        if (this.currToken != tkExpect) {
            return false;
        }
        this.currToken = st.nextToken();
        return true;
    }

    @Override
    public boolean ensureConsistency(ElementAttributes attributes, File root) {
        PortDefinition out;
        PortDefinition in;
        String label;
        block8: {
            String code = Application.getCode(attributes, root);
            VerilogTokenizer st = new VerilogTokenizer(new StringReader(code));
            this.currToken = st.nextToken();
            this.match(VerilogTokenizer.Token.MODULE, "keyword 'module'", st);
            label = st.value();
            this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
            ParamDefinition par = new ParamDefinition("");
            if (this.match0(VerilogTokenizer.Token.HASH, "'#'", st)) {
                this.match(VerilogTokenizer.Token.OPENPAR, "'('", st);
                this.scanParamArgs(st, par);
            }
            this.match(VerilogTokenizer.Token.OPENPAR, "'('", st);
            in = new PortDefinition("");
            out = new PortDefinition("");
            this.scanPortArgs(st, in, out, par);
            if (this.currToken == VerilogTokenizer.Token.SEMICOLON) {
                if (in.size() == 0 && out.size() == 0) {
                    do {
                        this.currToken = st.nextToken();
                        if (this.currToken != VerilogTokenizer.Token.INPUT && this.currToken != VerilogTokenizer.Token.OUTPUT) continue;
                        this.scanPort(st, in, out, par);
                    } while (this.currToken != VerilogTokenizer.Token.ENDMODULE && this.currToken != VerilogTokenizer.Token.EOF);
                }
                break block8;
            }
            return false;
        }
        try {
            if (in.size() > 0 && out.size() > 0) {
                attributes.set(Keys.LABEL, label);
                attributes.set(Keys.EXTERNAL_INPUTS, in.toString());
                attributes.set(Keys.EXTERNAL_OUTPUTS, out.toString());
                return true;
            }
            return false;
        }
        catch (ParseException | VerilogTokenizer.TokenizerException | IOException | NoSuchElementException e) {
            return false;
        }
    }

    private void scanParamArgs(VerilogTokenizer st, ParamDefinition par) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        block8: while (true) {
            switch (this.currToken) {
                case IDENT: {
                    this.currToken = st.nextToken();
                    continue block8;
                }
                case EQ: {
                    this.currToken = st.nextToken();
                    continue block8;
                }
                case NUMBER: {
                    this.currToken = st.nextToken();
                    continue block8;
                }
                case PARAMETER: {
                    this.scanParam(st, par);
                    this.currToken = st.nextToken();
                    continue block8;
                }
                case CLOSEPAR: {
                    this.currToken = st.nextToken();
                    return;
                }
                case COMMA: {
                    this.currToken = st.nextToken();
                    continue block8;
                }
            }
            break;
        }
        throw new ParseException("unexpected '" + st.value() + "'");
    }

    private void scanParam(VerilogTokenizer st, ParamDefinition par) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        if (this.currToken == VerilogTokenizer.Token.PARAMETER) {
            this.currToken = st.nextToken();
        }
        int bits = 32;
        if (this.currToken == VerilogTokenizer.Token.OPENBRACKET) {
            this.match(VerilogTokenizer.Token.OPENBRACKET, "", st);
            String rangeStart = st.value();
            this.match(VerilogTokenizer.Token.NUMBER, "a number", st);
            this.match(VerilogTokenizer.Token.COLON, "':'", st);
            String rangeEnd = st.value();
            this.match(VerilogTokenizer.Token.NUMBER, "a number", st);
            this.match(VerilogTokenizer.Token.CLOSEBRACKET, "']'", st);
            bits = Integer.parseInt(rangeStart) - Integer.parseInt(rangeEnd) + 1;
        }
        String name = st.value();
        this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
        this.match(VerilogTokenizer.Token.EQ, "'='", st);
        int val = Integer.parseInt(st.value());
        par.addParam(name, bits, val);
    }

    private void scanPortArgs(VerilogTokenizer st, PortDefinition in, PortDefinition out, ParamDefinition par) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        block6: while (true) {
            switch (this.currToken) {
                case IDENT: {
                    this.currToken = st.nextToken();
                    continue block6;
                }
                case INPUT: 
                case OUTPUT: {
                    this.scanPort(st, in, out, par);
                    continue block6;
                }
                case CLOSEPAR: {
                    this.currToken = st.nextToken();
                    return;
                }
                case COMMA: {
                    this.currToken = st.nextToken();
                    continue block6;
                }
            }
            break;
        }
        throw new ParseException("unexpected '" + st.value() + "'");
    }

    private void scanPort(VerilogTokenizer st, PortDefinition in, PortDefinition out, ParamDefinition par) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        boolean isInput;
        switch (this.currToken) {
            case INPUT: {
                isInput = true;
                this.currToken = st.nextToken();
                if (this.currToken != VerilogTokenizer.Token.WIRE && this.currToken != VerilogTokenizer.Token.LOGIC) break;
                this.currToken = st.nextToken();
                break;
            }
            case OUTPUT: {
                isInput = false;
                this.currToken = st.nextToken();
                if (this.currToken != VerilogTokenizer.Token.WIRE && this.currToken != VerilogTokenizer.Token.REG && this.currToken != VerilogTokenizer.Token.LOGIC) break;
                this.currToken = st.nextToken();
                break;
            }
            default: {
                throw new ParseException("unexpected '" + st.value() + "'");
            }
        }
        int bits = 1;
        if (this.currToken == VerilogTokenizer.Token.OPENBRACKET) {
            String namepar;
            this.match(VerilogTokenizer.Token.OPENBRACKET, "", st);
            int rangeStart = 0;
            int rangeEnd = 0;
            boolean isPlus = false;
            boolean isMinus = false;
            do {
                switch (this.currToken) {
                    case IDENT: {
                        namepar = st.value();
                        if (isPlus) {
                            rangeStart += par.getParamVal(namepar);
                            isPlus = false;
                        } else if (isMinus) {
                            rangeStart -= par.getParamVal(namepar);
                            isMinus = false;
                        } else {
                            rangeStart = par.getParamVal(namepar);
                        }
                        this.currToken = st.nextToken();
                        break;
                    }
                    case PLUS: {
                        isPlus = true;
                        this.currToken = st.nextToken();
                        break;
                    }
                    case MINUS: {
                        isMinus = true;
                        this.currToken = st.nextToken();
                        break;
                    }
                    case NUMBER: {
                        if (isPlus) {
                            rangeStart += Integer.parseInt(st.value());
                            isPlus = false;
                        } else if (isMinus) {
                            rangeStart -= Integer.parseInt(st.value());
                            isMinus = false;
                        } else {
                            rangeStart = Integer.parseInt(st.value());
                        }
                        this.currToken = st.nextToken();
                        break;
                    }
                }
            } while (this.currToken != VerilogTokenizer.Token.COLON);
            this.match(VerilogTokenizer.Token.COLON, "':'", st);
            do {
                switch (this.currToken) {
                    case IDENT: {
                        namepar = st.value();
                        if (isPlus) {
                            rangeEnd += par.getParamVal(namepar);
                            isPlus = false;
                        } else if (isMinus) {
                            rangeEnd -= par.getParamVal(namepar);
                            isMinus = false;
                        } else {
                            rangeEnd = par.getParamVal(namepar);
                        }
                        this.currToken = st.nextToken();
                        break;
                    }
                    case PLUS: {
                        isPlus = true;
                        this.currToken = st.nextToken();
                        break;
                    }
                    case MINUS: {
                        isMinus = true;
                        this.currToken = st.nextToken();
                        break;
                    }
                    case NUMBER: {
                        if (isPlus) {
                            rangeEnd += Integer.parseInt(st.value());
                            isPlus = false;
                        } else if (isMinus) {
                            rangeEnd -= Integer.parseInt(st.value());
                            isMinus = false;
                        } else {
                            rangeEnd = Integer.parseInt(st.value());
                        }
                        this.currToken = st.nextToken();
                        break;
                    }
                }
            } while (this.currToken != VerilogTokenizer.Token.CLOSEBRACKET);
            this.match(VerilogTokenizer.Token.CLOSEBRACKET, "']'", st);
            bits = rangeStart - rangeEnd + 1;
        }
        String name = st.value();
        this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
        if (isInput) {
            in.addPort(name, bits);
        } else {
            out.addPort(name, bits);
        }
        while (this.currToken == VerilogTokenizer.Token.COMMA) {
            this.match(VerilogTokenizer.Token.COMMA, "comma", st);
            if (this.currToken != VerilogTokenizer.Token.IDENT) {
                return;
            }
            name = st.value();
            this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
            if (isInput) {
                in.addPort(name, bits);
                continue;
            }
            out.addPort(name, bits);
        }
    }

    private static final class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }
}

