/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;

abstract class FlipflopBit
extends Node
implements Element {
    private final boolean isProbe;
    private final String label;
    private ObservableValue q;
    private ObservableValue qn;
    private boolean out;

    FlipflopBit(ElementAttributes attributes, ElementTypeDescription description) {
        super(true);
        this.q = new ObservableValue("Q", 1).setPinDescription(description);
        this.qn = new ObservableValue("~Q", 1).setPinDescription(description);
        this.isProbe = attributes.get(Keys.VALUE_IS_PROBE);
        this.label = attributes.getLabel();
        long def = attributes.get(Keys.DEFAULT);
        this.out = def > 0L;
        this.q.setBool(this.out);
        this.qn.setBool(!this.out);
    }

    FlipflopBit(String label, ObservableValue q, ObservableValue qn) {
        super(true);
        this.q = q;
        this.qn = qn;
        this.isProbe = false;
        this.label = label;
        q.setBool(false);
        qn.setBool(true);
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.q.setBool(this.out);
        this.qn.setBool(!this.out);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.q, this.qn);
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void registerNodes(Model model) {
        super.registerNodes(model);
        if (this.isProbe) {
            model.addSignal(new Signal(this.label, this.q, (v, z) -> {
                this.out = v != 0L;
                this.q.setBool(this.out);
                this.qn.setBool(!this.out);
            }).setTestOutput());
        }
    }

    void setOut(boolean out) {
        this.out = out;
    }

    boolean isOut() {
        return this.out;
    }
}

