/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MIDIHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MIDIHelper.class);
    private static MIDIHelper ourInstance = new MIDIHelper();
    private SynthesizerInterface synthesizer;
    private boolean isOpen;
    private TreeMap<String, Instrument> instrumentMap;

    public static MIDIHelper getInstance() {
        return ourInstance;
    }

    private MIDIHelper() {
    }

    private SynthesizerInterface getSynthesizer() throws NodeException {
        if (this.synthesizer == null) {
            try {
                Synthesizer synth = MidiSystem.getSynthesizer();
                if (synth == null) {
                    throw new NodeException(Lang.get("err_midiSystemNotAvailable", new Object[0]), new ObservableValue[0]);
                }
                this.synthesizer = new RealSynthesizer(synth);
            }
            catch (MidiUnavailableException e) {
                throw new NodeException(Lang.get("err_midiSystemNotAvailable", new Object[0]), e);
            }
        }
        return this.synthesizer;
    }

    private void ensureOpen(Model model) throws NodeException {
        if (!this.isOpen) {
            try {
                this.getSynthesizer().open();
            }
            catch (MidiUnavailableException e) {
                if (System.getProperty("testdata") == null) {
                    throw new NodeException(Lang.get("err_midiSystemNotAvailable", new Object[0]), e);
                }
                LOGGER.info("Use fake MIDI interface!");
                this.synthesizer = new SynthesizerMock();
            }
            this.isOpen = true;
            model.addObserver(event -> {
                if (event.getType().equals((Object)ModelEventType.CLOSED)) {
                    this.close();
                }
            }, ModelEventType.CLOSED, new ModelEventType[0]);
        }
    }

    private void close() {
        if (this.isOpen) {
            this.synthesizer.close();
            this.isOpen = false;
        }
    }

    public MidiChannel getChannel(int num, String instrument, Model model) throws NodeException {
        MidiChannel[] channels;
        this.ensureOpen(model);
        Instrument instr = null;
        if (!instrument.isEmpty()) {
            instr = this.getInstrument(instrument);
        }
        if (num >= (channels = this.getSynthesizer().getChannels()).length) {
            this.close();
            throw new NodeException(Lang.get("err_midiChannel_N_NotAvailable", num), new ObservableValue[0]);
        }
        MidiChannel channel = channels[num];
        if (channel == null) {
            this.close();
            throw new NodeException(Lang.get("err_midiChannel_N_NotAvailable", num), new ObservableValue[0]);
        }
        if (instr != null) {
            Patch patch = instr.getPatch();
            channel.programChange(patch.getBank(), patch.getProgram());
        }
        return channel;
    }

    public String[] getInstruments() throws NodeException {
        return new ArrayList<String>(this.getInstumentMap().keySet()).toArray(new String[0]);
    }

    private Instrument getInstrument(String instrument) throws NodeException {
        Instrument i = this.getInstumentMap().get(instrument);
        if (i == null) {
            throw new NodeException(Lang.get("err_midiInstrument_N_NotAvailable", instrument), new ObservableValue[0]);
        }
        return i;
    }

    private TreeMap<String, Instrument> getInstumentMap() throws NodeException {
        if (this.instrumentMap == null) {
            this.instrumentMap = new TreeMap();
            this.instrumentMap.put("", null);
            Instrument[] instrumentArray = this.getSynthesizer().getAvailableInstruments();
            int n = instrumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instrument i = instrumentArray[n2];
                this.instrumentMap.put(i.getName(), i);
                ++n2;
            }
        }
        return this.instrumentMap;
    }

    private static final class RealSynthesizer
    implements SynthesizerInterface {
        private final Synthesizer synthesizer;

        private RealSynthesizer(Synthesizer synthesizer) {
            this.synthesizer = synthesizer;
        }

        @Override
        public void open() throws MidiUnavailableException {
            this.synthesizer.open();
            Soundbank soundbank = this.synthesizer.getDefaultSoundbank();
            if (soundbank == null) {
                throw new MidiUnavailableException(Lang.get("err_midiInstrumentsNotAvailable", new Object[0]));
            }
            if (!this.synthesizer.loadAllInstruments(soundbank)) {
                throw new MidiUnavailableException(Lang.get("err_midiInstrumentsNotAvailable", new Object[0]));
            }
        }

        @Override
        public void close() {
            this.synthesizer.close();
        }

        @Override
        public Instrument[] getAvailableInstruments() {
            return this.synthesizer.getAvailableInstruments();
        }

        @Override
        public MidiChannel[] getChannels() {
            return this.synthesizer.getChannels();
        }
    }

    private static interface SynthesizerInterface {
        public void open() throws MidiUnavailableException;

        public void close();

        public Instrument[] getAvailableInstruments();

        public MidiChannel[] getChannels();
    }

    private static final class SynthesizerMock
    implements SynthesizerInterface {
        private SynthesizerMock() {
        }

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public Instrument[] getAvailableInstruments() {
            return new Instrument[0];
        }

        @Override
        public MidiChannel[] getChannels() {
            MidiChannel dummy = new MidiChannel(){

                @Override
                public void noteOn(int i, int i1) {
                }

                @Override
                public void noteOff(int i, int i1) {
                }

                @Override
                public void noteOff(int i) {
                }

                @Override
                public void setPolyPressure(int i, int i1) {
                }

                @Override
                public int getPolyPressure(int i) {
                    return 0;
                }

                @Override
                public void setChannelPressure(int i) {
                }

                @Override
                public int getChannelPressure() {
                    return 0;
                }

                @Override
                public void controlChange(int i, int i1) {
                }

                @Override
                public int getController(int i) {
                    return 0;
                }

                @Override
                public void programChange(int i) {
                }

                @Override
                public void programChange(int i, int i1) {
                }

                @Override
                public int getProgram() {
                    return 0;
                }

                @Override
                public void setPitchBend(int i) {
                }

                @Override
                public int getPitchBend() {
                    return 0;
                }

                @Override
                public void resetAllControllers() {
                }

                @Override
                public void allNotesOff() {
                }

                @Override
                public void allSoundOff() {
                }

                @Override
                public boolean localControl(boolean b) {
                    return false;
                }

                @Override
                public void setMono(boolean b) {
                }

                @Override
                public boolean getMono() {
                    return false;
                }

                @Override
                public void setOmni(boolean b) {
                }

                @Override
                public boolean getOmni() {
                    return false;
                }

                @Override
                public void setMute(boolean b) {
                }

                @Override
                public boolean getMute() {
                    return false;
                }

                @Override
                public void setSolo(boolean b) {
                }

                @Override
                public boolean getSolo() {
                    return false;
                }
            };
            return new MidiChannel[]{dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy, dummy};
        }
    }
}

