/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.ProgramCounter;

public class Counter
extends Node
implements Element,
ProgramCounter {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Counter.class, PinInfo.input("en"), PinInfo.input("C").setClock(), PinInfo.input("clr")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.LABEL).addAttribute(Keys.VALUE_IS_PROBE).addAttribute(Keys.IS_PROGRAM_COUNTER).supportsHDL();
    private final ObservableValue out;
    private final ObservableValue ovf;
    private final long maxValue;
    private final boolean probe;
    private final String label;
    private final boolean isProgramCounter;
    private ObservableValue clockIn;
    private ObservableValue clrIn;
    private ObservableValue enable;
    private boolean lastClock;
    private long counter;
    private boolean ovfOut = false;

    public Counter(ElementAttributes attributes) {
        super(true);
        int bits = attributes.getBits();
        this.out = new ObservableValue("out", bits).setPinDescription(DESCRIPTION);
        this.ovf = new ObservableValue("ovf", 1).setPinDescription(DESCRIPTION);
        this.maxValue = Bits.mask(bits);
        this.probe = attributes.get(Keys.VALUE_IS_PROBE);
        this.label = attributes.getLabel();
        this.isProgramCounter = attributes.get(Keys.IS_PROGRAM_COUNTER);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockIn.getBool();
        boolean enable = this.enable.getBool();
        if (clock && !this.lastClock) {
            if (enable) {
                this.counter = this.counter == this.maxValue ? 0L : ++this.counter;
            }
            if (this.clrIn.getBool()) {
                this.counter = 0L;
            }
        }
        this.lastClock = clock;
        this.ovfOut = this.counter == this.maxValue && enable;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.ovf.setBool(this.ovfOut);
        this.out.setValue(this.counter);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.enable = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, this, 0);
        this.clockIn = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
        this.clrIn = ((ObservableValue)inputs.get(2)).checkBits(1, this, 2);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.out, this.ovf);
    }

    @Override
    public void registerNodes(Model model) {
        super.registerNodes(model);
        if (this.probe) {
            model.addSignal(new Signal(this.label, this.out, (v, z) -> {
                this.counter = v;
                boolean o = this.counter == this.maxValue && this.enable.getBool();
                this.out.setValue(this.counter);
                this.ovf.setBool(o);
            }).setTestOutput());
        }
    }

    @Override
    public boolean isProgramCounter() {
        return this.isProgramCounter;
    }

    @Override
    public long getProgramCounter() {
        return this.counter;
    }
}

