/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;

public class RAMAsync
extends Node
implements Element,
RAMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(RAMAsync.class, PinInfo.input("A"), PinInfo.input("D"), PinInfo.input("we")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.LABEL).supportsHDL();
    private final DataField memory;
    private final ObservableValue output;
    private final int addrBits;
    private final int bits;
    private final String label;
    private final int size;
    private final boolean isProgramMemory;
    private ObservableValue we;
    private ObservableValue addrIn;
    private ObservableValue dataIn;
    private long outputVal;

    public RAMAsync(ElementAttributes attr) {
        super(true);
        this.bits = attr.get(Keys.BITS);
        this.output = new ObservableValue("Q", this.bits).setPinDescription(DESCRIPTION);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.size = 1 << this.addrBits;
        this.memory = new DataField(this.size);
        this.label = attr.getLabel();
        this.isProgramMemory = attr.isProgramMemory();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.addrIn = ((ObservableValue)inputs.get(0)).checkBits(this.addrBits, this).addObserverToValue(this);
        this.dataIn = ((ObservableValue)inputs.get(1)).checkBits(this.bits, this).addObserverToValue(this);
        this.we = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        int addr = (int)this.addrIn.getValue();
        if (this.we.getBool()) {
            this.memory.setData(addr, this.dataIn.getValue());
        }
        this.outputVal = this.memory.getDataWord(addr);
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(this.outputVal);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

