/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.ProgramMemory;
import de.neemann.digital.core.memory.importer.Importer;
import de.neemann.digital.core.memory.rom.ROMInterface;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;

public class ROM
extends Node
implements Element,
ROMInterface,
ProgramMemory {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(ROM.class, PinInfo.input("A"), PinInfo.input("sel")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.LABEL).addAttribute(Keys.DATA).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.AUTO_RELOAD_ROM).addAttribute(Keys.LAST_DATA_FILE).addAttribute(Keys.BIG_ENDIAN).supportsHDL();
    private DataField data;
    private final ValueFormatter formatter;
    private final ObservableValue output;
    private final int addrBits;
    private final int dataBits;
    private final boolean autoLoad;
    private final boolean isProgramMemory;
    private final ElementAttributes attr;
    private final String label;
    private ObservableValue addrIn;
    private ObservableValue selIn;
    private int addr;
    private boolean sel;

    public ROM(ElementAttributes attr) {
        this.dataBits = attr.get(Keys.BITS);
        this.output = this.createOutput1();
        this.data = attr.get(Keys.DATA);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.autoLoad = attr.get(Keys.AUTO_RELOAD_ROM);
        this.attr = this.autoLoad ? attr : null;
        this.label = attr.getLabel();
        this.isProgramMemory = attr.isProgramMemory();
        this.formatter = attr.getValueFormatter();
    }

    ObservableValue createOutput1() {
        return new ObservableValue("D", this.dataBits).setToHighZ().setPinDescription(DESCRIPTION);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.addrIn = ((ObservableValue)inputs.get(0)).checkBits(this.addrBits, this, 0).addObserverToValue(this);
        this.selIn = ((ObservableValue)inputs.get(1)).checkBits(1, this, 1).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void readInputs() throws NodeException {
        this.addr = (int)this.addrIn.getValue();
        this.sel = this.selIn.getBool();
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.sel) {
            this.output.setValue(this.getDataWord(this.addr));
        } else {
            this.output.setToHighZ();
        }
    }

    long getDataWord(int addr) {
        return this.data.getDataWord(addr);
    }

    @Override
    public void init(Model model) throws NodeException {
        if (this.autoLoad) {
            if (this.attr == null) {
                throw new NodeException(Lang.get("err_ROM_noFileGivenToLoad", new Object[0]), this, -1, null);
            }
            try {
                File f = this.attr.getFile(Keys.LAST_DATA_FILE, model.getRootPath());
                boolean bigEndian = this.attr.get(Keys.BIG_ENDIAN);
                this.data = Importer.read(f, this.dataBits, bigEndian);
            }
            catch (IOException e) {
                throw new NodeException(e.getMessage(), this, -1, null);
            }
        }
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.setData(dataField);
    }

    @Override
    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    @Override
    public void setData(DataField data) {
        this.data = data;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public ValueFormatter getValueFormatter() {
        return this.formatter;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }
}

