/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;

public class RegisterFile
extends Node
implements Element,
RAMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(RegisterFile.class, PinInfo.input("Din"), PinInfo.input("we"), PinInfo.input("Rw"), PinInfo.input("C").setClock(), PinInfo.input("Ra"), PinInfo.input("Rb")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.LABEL).supportsHDL();
    private final DataField memory;
    private final ObservableValue out1;
    private final ObservableValue out2;
    private final int addrBits;
    private final int bits;
    private final String label;
    private final int size;
    private ObservableValue reg1In;
    private ObservableValue reg2In;
    private ObservableValue regWIn;
    private ObservableValue data1In;
    private ObservableValue weIn;
    private ObservableValue clk1In;
    private int reg1;
    private int reg2;
    private boolean lastClk = false;

    public RegisterFile(ElementAttributes attr) {
        super(true);
        this.bits = attr.get(Keys.BITS);
        this.out1 = new ObservableValue("Da", this.bits).setPinDescription(DESCRIPTION);
        this.out2 = new ObservableValue("Db", this.bits).setPinDescription(DESCRIPTION);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.size = 1 << this.addrBits;
        this.memory = new DataField(this.size);
        this.label = attr.getLabel();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.data1In = ((ObservableValue)inputs.get(0)).checkBits(this.bits, this);
        this.weIn = ((ObservableValue)inputs.get(1)).checkBits(1, this);
        this.regWIn = ((ObservableValue)inputs.get(2)).checkBits(this.addrBits, this);
        this.clk1In = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
        this.reg1In = ((ObservableValue)inputs.get(4)).checkBits(this.addrBits, this).addObserverToValue(this);
        this.reg2In = ((ObservableValue)inputs.get(5)).checkBits(this.addrBits, this).addObserverToValue(this);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.out1, this.out2);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean str;
        boolean clk = this.clk1In.getBool();
        boolean bl = str = !this.lastClk && clk && this.weIn.getBool();
        if (str) {
            long data = this.data1In.getValue();
            int regW = (int)this.regWIn.getValue();
            this.memory.setData(regW, data);
        }
        this.reg1 = (int)this.reg1In.getValue();
        this.reg2 = (int)this.reg2In.getValue();
        this.lastClk = clk;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.out1.setValue(this.memory.getDataWord(this.reg1));
        this.out2.setValue(this.memory.getDataWord(this.reg2));
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public boolean isProgramMemory() {
        return false;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }
}

