/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class Driver
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Driver.class, PinInfo.input("in"), PinInfo.input("sel")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.INVERT_DRIVER_OUTPUT).addAttribute(Keys.FLIP_SEL_POSITON).supportsHDL();
    private final ObservableValue output;
    private final int bits;
    private final boolean invertOut;
    private ObservableValue input;
    private ObservableValue selIn;
    private long value;
    private boolean sel;

    public Driver(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.output = new ObservableValue("out", this.bits).setToHighZ().setPinDescription(DESCRIPTION);
        this.invertOut = attributes.get(Keys.INVERT_DRIVER_OUTPUT);
    }

    @Override
    public void readInputs() throws NodeException {
        this.value = this.input.getValue();
        this.sel = this.selIn.getBool();
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.isOutHighZ(this.sel)) {
            this.output.setToHighZ();
        } else if (this.invertOut) {
            this.output.setValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.output.setValue(this.value);
        }
    }

    protected boolean isOutHighZ(boolean sel) {
        return !sel;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this);
        this.selIn = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

