/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class DataBus {
    private final CommonBusValue commonBusValue;

    public DataBus(Net net, Model model, ArrayList<Pin> outputs) throws PinException {
        this(net, model, DataBus.createArray(outputs));
    }

    private static ObservableValue[] createArray(ArrayList<Pin> outputs) {
        ObservableValue[] o = new ObservableValue[outputs.size()];
        int i = 0;
        while (i < outputs.size()) {
            o[i] = outputs.get(i).getValue();
            ++i;
        }
        return o;
    }

    public DataBus(Net net, Model model, ObservableValue ... outputs) throws PinException {
        int bits = 0;
        PinDescription.PullResistor resistor = PinDescription.PullResistor.none;
        ObservableValue[] observableValueArray = outputs;
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue o = observableValueArray[n2];
            int b = o.getBits();
            if (bits == 0) {
                bits = b;
            } else if (bits != b) {
                throw new PinException(Lang.get("err_notAllOutputsSameBits", new Object[0]), net);
            }
            switch (o.getPullResistor()) {
                case pullDown: {
                    if (resistor == PinDescription.PullResistor.pullUp) {
                        throw new PinException(Lang.get("err_pullUpAndDownNotAllowed", new Object[0]), net);
                    }
                    resistor = PinDescription.PullResistor.pullDown;
                    break;
                }
                case pullUp: {
                    if (resistor == PinDescription.PullResistor.pullDown) {
                        throw new PinException(Lang.get("err_pullUpAndDownNotAllowed", new Object[0]), net);
                    }
                    resistor = PinDescription.PullResistor.pullUp;
                }
            }
            ++n2;
        }
        BusModelStateObserver obs = model.getOrCreateObserver(BusModelStateObserver.class, BusModelStateObserver::new);
        this.commonBusValue = new CommonBusValue(bits, obs, resistor, outputs, net == null ? null : net.getOrigin());
        ObservableValue[] observableValueArray2 = outputs;
        int n3 = outputs.length;
        n = 0;
        while (n < n3) {
            ObservableValue p = observableValueArray2[n];
            p.addObserverToValue(this.commonBusValue);
            ++n;
        }
        this.commonBusValue.hasChanged();
    }

    public ObservableValue getReadableOutput() {
        return this.commonBusValue;
    }
}

